/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.GroupMembershipFunction;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

@Deprecated
public class XMLDBRemoveUserFromGroup
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBRemoveUserFromGroup.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("remove-user-from-group", "http://exist-db.org/xquery/xmldb", "xmldb"), "Remove a user from a group. $user is the username. $group is the group nameThe XQuery owner must have appropriate privileges to do this, e.g. having DBA role.", new SequenceType[]{new FunctionParameterSequenceType("user", 22, 2, "The user name"), new FunctionParameterSequenceType("group", 22, 2, "The group name")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true() or false() indicating the outcome of the operation"), GroupMembershipFunction.FNS_REMOVE_GROUP_MEMBER);

    public XMLDBRemoveUserFromGroup(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if ("guest".equals(this.context.getSubject().getName())) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling account '" + this.context.getSubject().getName() + "' must be an authenticated user to call this function.");
            logger.error("Invalid account", (Throwable)xPathException);
            throw xPathException;
        }
        String userName = args[0].getStringValue();
        String groupName = args[1].getStringValue();
        logger.info("Attempting to remove user '" + userName + "' from group '" + groupName + "'");
        try {
            SecurityManager sm = this.context.getBroker().getBrokerPool().getSecurityManager();
            Account account = sm.getAccount(userName);
            account.remGroup(groupName);
            try {
                this.context.getBroker().pushSubject(sm.getSystemSubject());
                sm.updateAccount(account);
                return BooleanValue.TRUE;
            }
            finally {
                this.context.getBroker().popSubject();
            }
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, "Permission denied, calling account '" + this.context.getSubject().getName() + "' do not authorize to call this function.");
        }
        catch (EXistException exe) {
            logger.error("Failed to remove user '" + userName + "' from group '" + groupName + "'", (Throwable)exe);
            return BooleanValue.FALSE;
        }
    }
}

