/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBRename
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBRename.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("rename", "http://exist-db.org/xquery/xmldb", "xmldb"), "Renames the collection $source-collection-uri with new name $new-collection-name. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("source-collection-uri", 22, 2, "The source collection URI"), new FunctionParameterSequenceType("new-collection-name", 22, 2, "The new collection name")}, new SequenceType(11, 1)), new FunctionSignature(new QName("rename", "http://exist-db.org/xquery/xmldb", "xmldb"), "Renames the resource $resource in collection $collection-uri with new name $new-resource-name. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("resource", 22, 2, "The resource"), new FunctionParameterSequenceType("new-resource-name", 22, 2, "The new resource name")}, new SequenceType(11, 1))};

    public XMLDBRename(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.getSignature().getArgumentCount() == 3) {
            XmldbURI doc = new AnyURIValue(args[1].itemAt(0).getStringValue()).toXmldbURI();
            try {
                Resource resource = collection.getResource(doc.toString());
                if (resource == null) {
                    logger.error("Resource " + doc + " not found");
                    throw new XPathException((Expression)this, "Resource " + doc + " not found");
                }
                String newName = args[2].itemAt(0).getStringValue();
                EXistCollectionManagementService service = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                service.moveResource(doc, (XmldbURI)null, XmldbURI.xmldbUriFor(newName));
            }
            catch (XMLDBException e) {
                logger.error(e.getMessage());
                throw new XPathException((Expression)this, "XMLDB exception caught: " + e.getMessage(), (Throwable)e);
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage());
                throw new XPathException((Expression)this, "URI exception: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            String newName = args[1].itemAt(0).getStringValue();
            EXistCollectionManagementService service = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            service.move(XmldbURI.xmldbUriFor(collection.getName()), null, XmldbURI.xmldbUriFor(newName));
        }
        catch (XMLDBException e) {
            logger.error("Cannot rename collection: " + e.getMessage());
            throw new XPathException((Expression)this, "Cannot rename collection: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage());
            throw new XPathException((Expression)this, "URI exception: " + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

