/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

@Deprecated
public class XMLDBSetCollectionPermissions
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-collection-permissions", "http://exist-db.org/xquery/xmldb", "xmldb"), "Sets the permissions of the collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI. $user-id specifies the user which will become the owner of the resource, $group-id the group, and $permissons the permissions as an xs:integer value. PLEASE REMEMBER that octal number 0755 is 7*64+5*8+5 i.e. 493 in decimal NOT 755. You can use util:base-to-integer(0755, 8) as argument for convenience.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("user-id", 22, 2, "The user-id"), new FunctionParameterSequenceType("group-id", 22, 2, "The group-id"), new FunctionParameterSequenceType("permissions", 31, 2, "The permissions")}, new SequenceType(11, 1), "You should use sm:chown and sm:chmod from the SecurityManager Module instead.");

    public XMLDBSetCollectionPermissions(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            String user = args[1].getStringValue();
            String group = args[2].getStringValue();
            int mode = ((IntegerValue)args[3].convertTo(31)).getInt();
            if (null == user || 0 == user.length()) {
                logger.error("Needs a valid user name, not: " + user);
                throw new XPathException((Expression)this, "Needs a valid user name, not: " + user);
            }
            if (null == group || 0 == group.length()) {
                logger.error("Needs a valid group name, not: " + group);
                throw new XPathException((Expression)this, "Needs a valid group name, not: " + group);
            }
            Account usr = ums.getAccount(user);
            if (usr == null) {
                logger.error("Needs a valid user name, not: " + user);
                throw new XPathException((Expression)this, "Needs a valid user name, not: " + user);
            }
            ums.chown(usr, group);
            ums.chmod(mode);
        }
        catch (XMLDBException xe) {
            throw new XPathException((Expression)this, "Unable to change collection permissions: " + xe.getMessage(), (Throwable)xe);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

