/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class XMLDBSetMimeType
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBSetMimeType.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-mime-type", "http://exist-db.org/xquery/xmldb", "xmldb"), "Set the MIME type of the resource $resource-uri.Resource URIs can be specified either as a simple collection path, an XMLDB URI or any URI.", new SequenceType[]{new FunctionParameterSequenceType("resource-uri", 25, 2, "The resource URI"), new FunctionParameterSequenceType("mime-type", 22, 3, "The new mime-type, use empty sequence to set default value.")}, new SequenceType(10, 1));

    public XMLDBSetMimeType(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        MimeType currentMimeType;
        MimeTable mimeTable = MimeTable.getInstance();
        String pathParameter = new AnyURIValue(args[0].itemAt(0).getStringValue()).toString();
        if (pathParameter.matches("^[a-z]+://.*")) {
            throw new XPathException("Can not set mime-type for resources outside the database.");
        }
        XmldbURI pathUri = null;
        try {
            pathUri = XmldbURI.xmldbUriFor(pathParameter);
        }
        catch (URISyntaxException ex) {
            logger.debug(ex.getMessage());
            throw new XPathException("Invalid path '" + pathParameter + "'");
        }
        MimeType newMimeType = null;
        if (args[1].isEmpty()) {
            newMimeType = mimeTable.getContentTypeFor(pathParameter);
            if (newMimeType == null) {
                throw new XPathException("Unable to determine mimetype for '" + pathParameter + "'");
            }
        } else {
            newMimeType = mimeTable.getContentType(args[1].getStringValue());
            if (newMimeType == null) {
                throw new XPathException("mime-type '" + args[1].getStringValue() + "' is not supported.");
            }
        }
        if ((currentMimeType = this.getMimeTypeStoredResource(pathUri)) == null) {
            logger.debug("Resource '" + pathUri + "' has no mime-type, retrieve from document name.");
            currentMimeType = mimeTable.getContentTypeFor(pathUri);
            if (currentMimeType == null) {
                throw new XPathException("Unable to determine mime-type from path '" + pathUri + "'.");
            }
        }
        if (newMimeType.isXMLType() != currentMimeType.isXMLType()) {
            throw new XPathException("New mime-type must be a " + currentMimeType.getXMLDBType() + " mime-type");
        }
        DBBroker broker = this.context.getBroker();
        BrokerPool brokerPool = broker.getBrokerPool();
        DocumentImpl doc = null;
        try (Txn txn = brokerPool.getTransactionManager().beginTransaction();){
            pathUri = this.context.getBaseURI().toXmldbURI().resolveCollectionPath(pathUri);
            doc = broker.getXMLResource(pathUri, Lock.LockMode.WRITE_LOCK);
            if (doc == null) {
                txn.abort();
            } else {
                doc.getMetadata().setMimeType(newMimeType.getName());
                broker.storeMetadata(txn, doc);
                txn.commit();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new XPathException((Expression)this, (Throwable)e);
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeType getMimeTypeStoredResource(XmldbURI pathUri) throws XPathException {
        MimeType returnValue = null;
        DocumentImpl doc = null;
        try {
            pathUri = this.context.getBaseURI().toXmldbURI().resolveCollectionPath(pathUri);
        }
        catch (XPathException ex) {
            logger.debug("Unable to convert path " + pathUri);
            return returnValue;
        }
        try {
            doc = this.context.getBroker().getXMLResource(pathUri, Lock.LockMode.READ_LOCK);
            if (doc == null) {
                throw new XPathException("Resource '" + pathUri + "' does not exist.");
            }
            String mimetype = doc.getMetadata().getMimeType();
            returnValue = MimeTable.getInstance().getContentType(mimetype);
        }
        catch (PermissionDeniedException ex) {
            logger.debug(ex.getMessage());
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        return returnValue;
    }
}

