/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBSize
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBSize.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("size", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the estimated size of the resource $resource (in bytes) in the collection $collection-uri. The estimation is based on the number of pages occupied by the resource. If the document is serialized back to a string, its size may be different, since parts of the structural information are stored in compressed form. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("resource", 22, 2, "The resource")}, new FunctionReturnSequenceType(37, 2, "the size of the pages, occupied by the resource, in bytes"));

    public XMLDBSize(XQueryContext context) {
        super(context, signature);
    }

    @Override
    protected Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Resource resource = collection.getResource(new AnyURIValue(args[1].getStringValue()).toXmldbURI().toString());
            return new IntegerValue(((EXistResource)resource).getContentLength(), 37);
        }
        catch (XMLDBException e) {
            logger.error("Failed to retrieve size: " + e.getMessage());
            throw new XPathException((Expression)this, "Failed to retrieve size: " + e.getMessage(), (Throwable)e);
        }
    }
}

