/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class XMLDBURIFunctions
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBURIFunctions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("encode", "http://exist-db.org/xquery/xmldb", "xmldb"), "Encodes the string $string such that it will be a valid collection or resource path. Provides similar functionality to java's URLEncoder.encode() function, with some enhancements.", new SequenceType[]{new FunctionParameterSequenceType("string", 22, 2, "The input string")}, new FunctionReturnSequenceType(22, 2, "the URL encoded string")), new FunctionSignature(new QName("encode-uri", "http://exist-db.org/xquery/xmldb", "xmldb"), "Encodes the string $string such that it will be a valid collection or resource path. Provides similar functionality to java's URLEncoder.encode() function, with some enhancements. Returns an xs:anyURI object representing a valid XmldbURI", new SequenceType[]{new FunctionParameterSequenceType("string", 22, 2, "The input string")}, new FunctionReturnSequenceType(25, 2, "the XmldbURI encoded from $string")), new FunctionSignature(new QName("decode", "http://exist-db.org/xquery/xmldb", "xmldb"), "Decodes the string $string such that any percent encoded octets will be translated to their decoded UTF-8 representation.", new SequenceType[]{new FunctionParameterSequenceType("string", 22, 2, "The input string")}, new FunctionReturnSequenceType(22, 2, "the decoded string")), new FunctionSignature(new QName("decode-uri", "http://exist-db.org/xquery/xmldb", "xmldb"), "Decodes the URI $uri such that any percent encoded octets will be translated to their decoded UTF-8 representation.", new SequenceType[]{new FunctionParameterSequenceType("uri", 25, 2, "The URI")}, new FunctionReturnSequenceType(22, 2, "the decoded $uri as xs:string"))};

    public XMLDBURIFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        block7: {
            block6: {
                if (!this.isCalledAs("encode")) break block6;
                StringValue stringValue = new StringValue(URIUtils.urlEncodePartsUtf8(args[0].getStringValue()));
                return stringValue;
            }
            if (!this.isCalledAs("encode-uri")) break block7;
            AnyURIValue anyURIValue = new AnyURIValue(URIUtils.encodeXmldbUriFor(args[0].getStringValue()));
            return anyURIValue;
        }
        try {
            StringValue stringValue = new StringValue(URIUtils.urlDecodeUtf8(args[0].getStringValue()));
            return stringValue;
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new XPathException((Expression)this, "URI Syntax Exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

