/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.FindGroupFunction;
import org.exist.xquery.functions.securitymanager.FindUserFunction;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.XMLDBException;

@Deprecated
public class XMLDBUserAccess
extends BasicFunction {
    protected static final FunctionParameterSequenceType ARG_USER_ID = new FunctionParameterSequenceType("user-id", 22, 2, "The user-id");
    protected static final Logger logger = LogManager.getLogger(XMLDBUserAccess.class);
    public static final FunctionSignature fnExistsUser = new FunctionSignature(new QName("exists-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns true if the user $user-id exists.", new SequenceType[]{ARG_USER_ID}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true() if the user exists, false() otherwise"), FindUserFunction.FNS_USER_EXISTS);
    public static final FunctionSignature fnUserGroups = new FunctionSignature(new QName("get-user-groups", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the sequence of groups the user $user-id is a member of.", new SequenceType[]{ARG_USER_ID}, (SequenceType)new FunctionReturnSequenceType(22, 6, "the group memberships"), FindGroupFunction.FNS_GET_USER_GROUPS);
    public static final FunctionSignature fnUserPrimaryGroup = new FunctionSignature(new QName("get-user-primary-group", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the user's primary group.", new SequenceType[]{ARG_USER_ID}, (SequenceType)new FunctionReturnSequenceType(22, 2, "The Primary Group of the User"), FindGroupFunction.FNS_GET_USER_PRIMARY_GROUP);
    public static final FunctionSignature fnUserHome = new FunctionSignature(new QName("get-user-home", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the user's home collection URI or the empty sequence if no home collection is assigned to the user $user-id.", new SequenceType[]{ARG_USER_ID}, (SequenceType)new FunctionReturnSequenceType(25, 3, "the home collection URI of user $user-id if one is assigned, otherwise the empty sequence"), "Users do not have home collections since 2.0. Will return /db.");

    public XMLDBUserAccess(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String userName = args[0].getStringValue();
        LocalCollection collection = null;
        try {
            collection = new LocalCollection(this.context.getSubject(), this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI);
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            Account user = ums.getAccount(userName);
            if (this.isCalledAs("exists-user")) {
                BooleanValue booleanValue = null == user ? BooleanValue.FALSE : BooleanValue.TRUE;
                return booleanValue;
            }
            if (user == null) {
                logger.error("User not found: " + userName);
                throw new XPathException((Expression)this, "User not found: " + userName);
            }
            if (this.isCalledAs("get-user-primary-group")) {
                StringValue stringValue = new StringValue(user.getPrimaryGroup());
                return stringValue;
            }
            if (this.isCalledAs("get-user-groups")) {
                ValueSequence groups = new ValueSequence();
                String[] gl = user.getGroups();
                int i = 0;
                while (true) {
                    if (i >= gl.length) {
                        ValueSequence valueSequence = groups;
                        return valueSequence;
                    }
                    groups.add(new StringValue(gl[i]));
                    ++i;
                }
            }
            XmldbURI home = XmldbURI.DB;
            Sequence sequence = null == home ? Sequence.EMPTY_SEQUENCE : new AnyURIValue(home);
            return sequence;
        }
        catch (XMLDBException e) {
            logger.error(e.getMessage());
            throw new XPathException((Expression)this, "Failed to query user " + userName, (Throwable)e);
        }
        finally {
            if (null != collection) {
                try {
                    collection.close();
                }
                catch (XMLDBException xMLDBException) {}
            }
        }
    }
}

