/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.serializer.ExtendedDOMSerializer;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

public class XMLDBXUpdate
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBXUpdate.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("update", "http://exist-db.org/xquery/xmldb", "xmldb"), "Processes an XUpdate request, $modifications, against a collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.The modifications are passed in a document conforming to the XUpdate specification. http://rx4rdf.liminalzone.org/xupdate-wd.html#N1a32e0The function returns the number of modifications caused by the XUpdate.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("modifications", -1, 2, "The XUpdate modifications to be processed")}, new FunctionReturnSequenceType(31, 2, "the number of modifications, as xs:integer, caused by the XUpdate"));

    public XMLDBXUpdate(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection c, Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeValue data = (NodeValue)args[1].itemAt(0);
        StringWriter writer = new StringWriter();
        Properties properties = new Properties();
        properties.setProperty("indent", "yes");
        ExtendedDOMSerializer serializer = new ExtendedDOMSerializer(this.context.getBroker(), writer, properties);
        try {
            serializer.serialize(data.getNode());
        }
        catch (TransformerException e) {
            logger.debug("Exception while serializing XUpdate document", (Throwable)e);
            throw new XPathException((Expression)this, "Exception while serializing XUpdate document: " + e.getMessage(), (Throwable)e);
        }
        String xupdate = writer.toString();
        long modifications = 0L;
        try {
            XUpdateQueryService service = (XUpdateQueryService)c.getService("XUpdateQueryService", "1.0");
            logger.debug("Processing XUpdate request: " + xupdate);
            modifications = service.update(xupdate);
        }
        catch (XMLDBException e) {
            throw new XPathException((Expression)this, "Exception while processing xupdate: " + e.getMessage(), (Throwable)e);
        }
        this.context.getRootExpression().resetState(false);
        return new IntegerValue(modifications);
    }
}

