/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules;

import com.evolvedbinary.j8fu.Either;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.util.HtmlToXmlParser;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NodeValue;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ModuleUtils {
    protected static final Logger LOG = LogManager.getLogger(ModuleUtils.class);
    private static final ContextMapLocks contextMapLocks = new ContextMapLocks();
    private static final Random random = new Random();

    public static NodeValue stringToXML(XQueryContext context, String str) throws SAXException, IOException {
        try (StringReader reader = new StringReader(str);){
            NodeValue nodeValue = ModuleUtils.inputSourceToXML(context, new InputSource(reader));
            return nodeValue;
        }
    }

    public static NodeValue streamToXML(XQueryContext context, InputStream is) throws SAXException, IOException {
        return ModuleUtils.inputSourceToXML(context, new InputSource(is));
    }

    public static NodeValue sourceToXML(XQueryContext context, Source src) throws SAXException, IOException {
        if (src instanceof SAXSource && ((SAXSource)src).getXMLReader() != null) {
            return ModuleUtils.inputSourceToXML(context, (SAXSource)src);
        }
        InputSource inputSource = SAXSource.sourceToInputSource(src);
        if (inputSource == null) {
            throw new IOException(src.getClass().getName() + " is unsupported.");
        }
        return ModuleUtils.inputSourceToXML(context, inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeValue inputSourceToXML(XQueryContext context, InputSource inputSource) throws SAXException, IOException {
        context.pushDocumentContext();
        XMLReader reader = null;
        try {
            reader = context.getBroker().getBrokerPool().getParserPool().borrowXMLReader();
            LOG.debug("Parsing XML response ...");
            MemTreeBuilder builder = context.getDocumentBuilder();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder, true);
            reader.setContentHandler(receiver);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", receiver);
            reader.parse(inputSource);
            Document doc = receiver.getDocument();
            NodeValue nodeValue = (NodeValue)((Object)doc);
            return nodeValue;
        }
        finally {
            context.popDocumentContext();
            if (reader != null) {
                context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NodeValue inputSourceToXML(XQueryContext context, SAXSource src) throws SAXException, IOException {
        if (src.getXMLReader() == null) {
            throw new SAXException("No XML Reader specified.");
        }
        XMLReader reader = src.getXMLReader();
        context.pushDocumentContext();
        try {
            MemTreeBuilder builder = context.getDocumentBuilder();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder, true);
            reader.setContentHandler(receiver);
            reader.parse(src.getInputSource());
            Document doc = receiver.getDocument();
            NodeValue nodeValue = (NodeValue)((Object)doc);
            return nodeValue;
        }
        finally {
            context.popDocumentContext();
        }
    }

    public static DocumentImpl htmlToXHtml(XQueryContext context, Source srcHtml, Map<String, Boolean> parserFeatures, Map<String, String> parserProperties) throws IOException, SAXException {
        InputSource inputSource = SAXSource.sourceToInputSource(srcHtml);
        if (inputSource == null) {
            throw new IOException(srcHtml.getClass().getName() + " is unsupported.");
        }
        return ModuleUtils.htmlToXHtml(context, inputSource, parserFeatures, parserProperties);
    }

    public static DocumentImpl htmlToXHtml(XQueryContext context, InputSource srcHtml, Map<String, Boolean> parserFeatures, Map<String, String> parserProperties) throws IOException, SAXException {
        Optional<Either<Throwable, XMLReader>> maybeReaderInst = HtmlToXmlParser.getHtmlToXmlParser(context.getBroker().getConfiguration());
        if (maybeReaderInst.isPresent()) {
            DocumentImpl documentImpl;
            Either<Throwable, XMLReader> readerInst = maybeReaderInst.get();
            if (readerInst.isLeft()) {
                String msg = "Unable to parse HTML to XML please ensure the parser is configured in conf.xml and is present on the classpath";
                Throwable t = (Throwable)readerInst.left().get();
                LOG.error("Unable to parse HTML to XML please ensure the parser is configured in conf.xml and is present on the classpath", t);
                throw new IOException("Unable to parse HTML to XML please ensure the parser is configured in conf.xml and is present on the classpath", t);
            }
            XMLReader reader = (XMLReader)readerInst.right().get();
            if (parserFeatures != null) {
                for (Map.Entry<String, Object> entry : parserFeatures.entrySet()) {
                    reader.setFeature(entry.getKey(), (Boolean)entry.getValue());
                }
            }
            if (parserProperties != null) {
                for (Map.Entry<String, Object> entry : parserProperties.entrySet()) {
                    reader.setProperty(entry.getKey(), entry.getValue());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Converting HTML to XML using: " + reader.getClass().getName());
            }
            SAXAdapter adapter = new SAXAdapter();
            adapter.setReplaceAttributeFlag(true);
            reader.setContentHandler(adapter);
            reader.parse(srcHtml);
            DocumentImpl memtreeDoc = documentImpl = adapter.getDocument();
            memtreeDoc.setContext(context);
            return memtreeDoc;
        }
        throw new SAXException("There is no HTML to XML parser configured in conf.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T retrieveObjectFromContextMap(XQueryContext context, String contextMapName, long objectUID) {
        contextMapLocks.getReadLock(contextMapName).lock();
        try {
            HashMap map = (HashMap)context.getXQueryContextVar(contextMapName);
            if (map == null) {
                T t = null;
                return t;
            }
            Object v = map.get(objectUID);
            return (T)v;
        }
        finally {
            contextMapLocks.getReadLock(contextMapName).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void modifyContextMap(XQueryContext context, String contextMapName, ContextMapModifier<T> modifier) {
        contextMapLocks.getWriteLock(contextMapName).lock();
        try {
            HashMap map = (HashMap)context.getXQueryContextVar(contextMapName);
            if (map == null) {
                map = new HashMap();
                context.setXQueryContextVar(contextMapName, map);
            }
            modifier.modify(map);
        }
        finally {
            contextMapLocks.getWriteLock(contextMapName).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long storeObjectInContextMap(XQueryContext context, String contextMapName, T o) {
        contextMapLocks.getWriteLock(contextMapName).lock();
        try {
            HashMap<Long, T> map = (HashMap<Long, T>)context.getXQueryContextVar(contextMapName);
            if (map == null) {
                map = new HashMap<Long, T>();
            }
            long uid = 0L;
            while (uid == 0L || map.keySet().contains(uid)) {
                uid = ModuleUtils.getUID();
            }
            map.put(uid, o);
            context.setXQueryContextVar(contextMapName, map);
            long l = uid;
            return l;
        }
        finally {
            contextMapLocks.getWriteLock(contextMapName).unlock();
        }
    }

    private static long getUID() {
        BigInteger bi = new BigInteger(64, random);
        return bi.longValue();
    }

    public static abstract class ContextMapEntryModifier<T>
    implements ContextMapModifier<T> {
        @Override
        public void modify(Map<Long, T> map) {
            for (Map.Entry<Long, T> entry : map.entrySet()) {
                this.modify(entry);
            }
        }

        @Override
        public abstract void modify(Map.Entry<Long, T> var1);
    }

    public static interface ContextMapModifier<T> {
        public void modify(Map<Long, T> var1);
    }

    private static class ContextMapLocks {
        private final Map<String, ReentrantReadWriteLock> locks = new HashMap<String, ReentrantReadWriteLock>();

        private ContextMapLocks() {
        }

        private synchronized ReentrantReadWriteLock getLock(String contextMapName) {
            ReentrantReadWriteLock lock = this.locks.get(contextMapName);
            if (lock == null) {
                lock = new ReentrantReadWriteLock();
                this.locks.put(contextMapName, lock);
            }
            return lock;
        }

        public ReentrantReadWriteLock.ReadLock getReadLock(String contextMapName) {
            return this.getLock(contextMapName).readLock();
        }

        public ReentrantReadWriteLock.WriteLock getWriteLock(String contextMapName) {
            return this.getLock(contextMapName).writeLock();
        }
    }
}

