/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.pragmas;

import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.StructuralIndex;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.Expression;
import org.exist.xquery.FilteredExpression;
import org.exist.xquery.Function;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.LocationStep;
import org.exist.xquery.Optimizable;
import org.exist.xquery.Option;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Pragma;
import org.exist.xquery.Predicate;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class Optimize
extends Pragma {
    public static final QName OPTIMIZE_PRAGMA = new QName("optimize", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final Logger LOG = LogManager.getLogger(Optimize.class);
    private boolean enabled = true;
    private XQueryContext context;
    private Optimizable[] optimizables;
    private Expression innerExpr = null;
    private LocationStep contextStep = null;
    private VariableReference contextVar = null;
    private int contextId = -1;
    private NodeSet cachedContext = null;
    private int cachedTimestamp;
    private boolean cachedOptimize;

    public Optimize(XQueryContext context, QName pragmaName, String contents, boolean explicit) throws XPathException {
        super(pragmaName, contents);
        this.context = context;
        boolean bl = this.enabled = explicit || context.optimizationsEnabled();
        if (contents != null && contents.length() > 0) {
            String[] param = Option.parseKeyValuePair(contents);
            if (param == null) {
                throw new XPathException("Invalid content found for pragma exist:optimize: " + contents);
            }
            if ("enable".equals(param[0])) {
                this.enabled = "yes".equals(param[1]);
            }
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.contextId = contextInfo.getContextId();
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        boolean useCached = false;
        boolean optimize = false;
        NodeSet originalContext = null;
        if (contextSequence == null || contextSequence.isPersistentSet()) {
            NodeSet nodeSet = originalContext = contextSequence == null ? null : contextSequence.toNodeSet();
            if (this.cachedContext != null && this.cachedContext == originalContext) {
                boolean bl = useCached = !originalContext.hasChanged(this.cachedTimestamp);
            }
            if (this.contextVar != null) {
                contextSequence = this.contextVar.eval(contextSequence);
            }
            if (useCached) {
                optimize = this.cachedOptimize;
            } else if (this.optimizables != null && this.optimizables.length > 0) {
                for (int i = 0; i < this.optimizables.length; ++i) {
                    if (!this.optimizables[i].canOptimize(contextSequence)) {
                        optimize = false;
                        break;
                    }
                    optimize = true;
                }
            }
        }
        if (optimize) {
            this.cachedContext = originalContext;
            this.cachedTimestamp = originalContext == null ? 0 : originalContext.getState();
            this.cachedOptimize = true;
            NodeSet result = null;
            for (int current = 0; current < this.optimizables.length; ++current) {
                NodeSet ancestors;
                NodeSet selection = this.optimizables[current].preSelect(contextSequence, current > 0);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("exist:optimize: pre-selection: " + selection.getLength());
                }
                if (selection.isEmpty()) {
                    ancestors = selection;
                } else if (this.contextStep == null || current > 0) {
                    ancestors = selection.selectAncestorDescendant(contextSequence.toNodeSet(), 0, true, this.contextId, true);
                } else {
                    long start = System.currentTimeMillis();
                    StructuralIndex index = this.context.getBroker().getStructuralIndex();
                    QName ancestorQN = this.contextStep.getTest().getName();
                    ancestors = this.optimizables[current].optimizeOnSelf() ? index.findAncestorsByTagName(ancestorQN.getNameType(), ancestorQN, 12, selection.getDocumentSet(), selection, this.contextId) : index.findAncestorsByTagName(ancestorQN.getNameType(), ancestorQN, this.optimizables[current].optimizeOnChild() ? 2 : 1, selection.getDocumentSet(), selection, this.contextId);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Ancestor selection took " + (System.currentTimeMillis() - start));
                        LOG.trace("Found: " + ancestors.getLength());
                    }
                }
                result = ancestors;
                contextSequence = result;
            }
            if (this.contextStep == null) {
                return this.innerExpr.eval(result);
            }
            this.contextStep.setPreloadedData(result.getDocumentSet(), result);
            if (LOG.isTraceEnabled()) {
                LOG.trace("exist:optimize: context after optimize: " + result.getLength());
            }
            long start = System.currentTimeMillis();
            contextSequence = originalContext != null ? originalContext.filterDocuments(result) : null;
            Sequence seq = this.innerExpr.eval(contextSequence);
            if (LOG.isTraceEnabled()) {
                LOG.trace("exist:optimize: inner expr took " + (System.currentTimeMillis() - start) + "; found: " + seq.getItemCount());
            }
            return seq;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("exist:optimize: Cannot optimize expression.");
        }
        if (originalContext != null) {
            contextSequence = originalContext;
        }
        return this.innerExpr.eval(contextSequence, contextItem);
    }

    @Override
    public void before(XQueryContext context, Expression expression, Sequence contextSequence) throws XPathException {
        if (this.innerExpr != null) {
            return;
        }
        this.innerExpr = expression;
        if (!this.enabled) {
            return;
        }
        this.innerExpr.accept(new BasicExpressionVisitor(){

            @Override
            public void visitPathExpr(PathExpr expression) {
                for (int i = 0; i < expression.getLength(); ++i) {
                    Expression next = expression.getExpression(i);
                    next.accept(this);
                }
            }

            @Override
            public void visitLocationStep(LocationStep locationStep) {
                List<Predicate> predicates = locationStep.getPredicates();
                for (Predicate pred : predicates) {
                    pred.accept(this);
                }
            }

            @Override
            public void visitFilteredExpr(FilteredExpression filtered) {
                Expression filteredExpr = filtered.getExpression();
                if (filteredExpr instanceof VariableReference) {
                    Optimize.this.contextVar = (VariableReference)filteredExpr;
                }
                List<Predicate> predicates = filtered.getPredicates();
                for (Predicate pred : predicates) {
                    pred.accept(this);
                }
            }

            @Override
            public void visit(Expression expression) {
                super.visit(expression);
            }

            @Override
            public void visitGeneralComparison(GeneralComparison comparison) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("exist:optimize: found optimizable: " + comparison.getClass().getName());
                }
                Optimize.this.addOptimizable(comparison);
            }

            @Override
            public void visitPredicate(Predicate predicate) {
                predicate.getExpression(0).accept(this);
            }

            @Override
            public void visitBuiltinFunction(Function function) {
                if (function instanceof Optimizable) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("exist:optimize: found optimizable function: " + function.getClass().getName());
                    }
                    Optimize.this.addOptimizable((Optimizable)((Object)function));
                }
            }
        });
        this.contextStep = BasicExpressionVisitor.findFirstStep(this.innerExpr);
        if (this.contextStep != null && this.contextStep.getTest().isWildcardTest()) {
            this.contextStep = null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("exist:optimize: context step: " + this.contextStep);
            LOG.trace("exist:optimize: context var: " + this.contextVar);
        }
    }

    @Override
    public void after(XQueryContext context, Expression expression) throws XPathException {
    }

    private void addOptimizable(Optimizable optimizable) {
        int axis = optimizable.getOptimizeAxis();
        if (axis != 5 && axis != 12 && axis != 7 && axis != 8 && axis != 6 && axis != 13) {
            return;
        }
        if (this.optimizables == null) {
            this.optimizables = new Optimizable[1];
            this.optimizables[0] = optimizable;
        } else {
            Optimizable[] o = new Optimizable[this.optimizables.length + 1];
            System.arraycopy(this.optimizables, 0, o, 0, this.optimizables.length);
            o[this.optimizables.length] = optimizable;
            this.optimizables = o;
        }
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.cachedContext = null;
    }

    public static int getQNameIndexType(XQueryContext context, Sequence contextSequence, QName qname) {
        if (contextSequence == null || qname == null) {
            return 11;
        }
        String enforceIndexUse = (String)context.getBroker().getConfiguration().getProperty("xquery.enforce-index-use");
        int indexType = 11;
        Iterator<Collection> i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = i.next();
            if (collection.getURI().startsWith(XmldbURI.SYSTEM_COLLECTION_URI)) continue;
            QNameRangeIndexSpec config = collection.getIndexByQNameConfiguration(context.getBroker(), qname);
            if (config == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Cannot optimize: collection " + collection.getURI() + " does not define an index on " + qname);
                }
                if (enforceIndexUse != null && "always".equals(enforceIndexUse)) continue;
                return 11;
            }
            int type = config.getType();
            if (indexType == 11) {
                indexType = type;
                if (enforceIndexUse == null || !"always".equals(enforceIndexUse)) continue;
                return indexType;
            }
            if (indexType == type) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cannot optimize: collection " + collection.getURI() + " does not define an index with the required type " + Type.getTypeName(type) + " on " + qname);
            }
            return 11;
        }
        return indexType;
    }
}

