/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.pragmas;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.Option;
import org.exist.xquery.Pragma;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Sequence;

public class TimerPragma
extends Pragma {
    public static final QName TIMER_PRAGMA = new QName("timer", "http://exist.sourceforge.net/NS/exist", "exist");
    private Logger log = null;
    private long start;
    private boolean verbose = true;

    public TimerPragma(QName qname, String contents) throws XPathException {
        super(qname, contents);
        if (contents != null && contents.length() > 0) {
            String[] options = Option.tokenize(contents);
            for (int i = 0; i < options.length; ++i) {
                String[] param = Option.parseKeyValuePair(options[i]);
                if (param == null) {
                    throw new XPathException("Invalid content found for pragma " + TIMER_PRAGMA.getStringValue() + ": " + contents);
                }
                if ("verbose".equals(param[0])) {
                    this.verbose = "yes".equals(param[1]);
                    continue;
                }
                if (!"logger".equals(param[0])) continue;
                this.log = LogManager.getLogger((String)param[1]);
            }
        }
        if (this.log == null) {
            this.log = LogManager.getLogger(TimerPragma.class);
        }
    }

    @Override
    public void after(XQueryContext context, Expression expression) throws XPathException {
        long elapsed = System.currentTimeMillis() - this.start;
        if (this.log.isTraceEnabled()) {
            if (this.verbose) {
                this.log.trace("Elapsed: " + elapsed + "ms. for expression:\n" + ExpressionDumper.dump(expression));
            } else {
                this.log.trace("Elapsed: " + elapsed + "ms.");
            }
        }
    }

    @Override
    public void before(XQueryContext context, Expression expression, Sequence contextSequence) throws XPathException {
        this.start = System.currentTimeMillis();
    }
}

