/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.regex;

import javax.annotation.Nullable;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.regex.JDK15RegexTranslator;
import org.exist.xquery.regex.RegexSyntaxException;
import org.exist.xquery.value.StringValue;

public class RegexUtil {
    public static int parseFlags(Expression context, @Nullable String strFlags) throws XPathException {
        int flags = 0;
        if (strFlags != null) {
            block7: for (int i = 0; i < strFlags.length(); ++i) {
                char ch = strFlags.charAt(i);
                switch (ch) {
                    case 'm': {
                        flags |= 8;
                        continue block7;
                    }
                    case 'i': {
                        flags = flags | 2 | 0x40;
                        continue block7;
                    }
                    case 'x': {
                        flags |= 4;
                        continue block7;
                    }
                    case 's': {
                        flags |= 0x20;
                        continue block7;
                    }
                    case 'q': {
                        flags |= 0x10;
                        continue block7;
                    }
                    default: {
                        throw new XPathException(context, ErrorCodes.FORX0001, "Invalid regular expression flag: " + ch, new StringValue(String.valueOf(ch)));
                    }
                }
            }
        }
        return flags;
    }

    public static boolean hasLiteral(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean hasCaseInsensitive(int flags) {
        return (flags & 2) != 0 || (flags & 0x40) != 0;
    }

    public static boolean hasIgnoreWhitespace(int flags) {
        return (flags & 4) != 0;
    }

    public static String translateRegexp(Expression context, String pattern, boolean ignoreWhitespace, boolean caseBlind) throws XPathException {
        try {
            int xmlVersion = 11;
            return JDK15RegexTranslator.translate(pattern, 11, true, ignoreWhitespace, caseBlind);
        }
        catch (RegexSyntaxException e) {
            throw new XPathException(context, ErrorCodes.FORX0002, "Conversion from XPath F&O 3.0 regular expression syntax to Java regular expression syntax failed: " + e.getMessage(), new StringValue(pattern), e);
        }
    }
}

