/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Attr;

public class Delete
extends Modification {
    public Delete(XQueryContext context, Expression select) {
        super(context, select, null);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence inSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (!Type.subTypeOf((inSeq = this.select.eval(contextSequence)).getItemType(), -1)) {
            ValueSequence prevUpdateErrors = null;
            XPathException xpe = new XPathException((Expression)this, Messages.getMessage("D08"));
            Object ctxVarObj = this.context.getXQueryContextVar("_eXist_xquery_update_error");
            prevUpdateErrors = ctxVarObj == null ? new ValueSequence() : (ValueSequence)XPathUtil.javaObjectToXPath(ctxVarObj, this.context);
            prevUpdateErrors.add(new StringValue(xpe.getMessage()));
            this.context.setXQueryContextVar("_eXist_xquery_update_error", prevUpdateErrors);
            if (!inSeq.isEmpty()) {
                throw xpe;
            }
        }
        if (!inSeq.isEmpty()) {
            try (Txn transaction = this.getTransaction();){
                StoredNode[] ql;
                NotificationService notifier = this.context.getBroker().getBrokerPool().getNotificationService();
                for (StoredNode node : ql = this.selectAndLock(transaction, inSeq)) {
                    DocumentImpl doc = node.getOwnerDocument();
                    if (!doc.getPermissions().validate(this.context.getSubject(), 2)) {
                        throw new PermissionDeniedException("User '" + this.context.getSubject().getName() + "' does not have permission to write to the document '" + doc.getDocumentURI() + "'!");
                    }
                    NodeImpl parent = node.getNodeType() == 2 ? (NodeImpl)((Object)((Attr)((Object)node)).getOwnerElement()) : (NodeImpl)node.getParentNode();
                    if (parent == null) {
                        LOG.debug("Cannot remove the document element (no parent node)");
                        throw new XPathException((Expression)this, "It is not possible to remove the document element.");
                    }
                    if (parent.getNodeType() != 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("parent = " + parent.getNodeType() + "; " + parent.getNodeName());
                        }
                        throw new XPathException((Expression)this, "you cannot remove the document element. Use update instead");
                    }
                    parent.removeChild(transaction, node);
                    doc.getMetadata().setLastModified(System.currentTimeMillis());
                    this.modifiedDocuments.add(doc);
                    this.context.getBroker().storeXMLResource(transaction, doc);
                    notifier.notifyUpdate(doc, 1);
                }
                this.finishTriggers(transaction);
                transaction.commit();
            }
            catch (EXistException | TriggerException | PermissionDeniedException | LockException e) {
                throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
            }
            finally {
                this.unlockDocuments();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("delete").nl();
        dumper.startIndent();
        this.select.dump(dumper);
        dumper.nl().endIndent();
    }

    public String toString() {
        return "'Delete' string representation";
    }
}

