/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.DocumentTriggers;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Modification
extends AbstractExpression {
    protected static final Logger LOG = LogManager.getLogger(Modification.class);
    protected final Expression select;
    protected final Expression value;
    protected DocumentSet lockedDocuments = null;
    protected MutableDocumentSet modifiedDocuments = new DefaultDocumentSet();
    protected Int2ObjectHashMap<DocumentTrigger> triggers;

    public Modification(XQueryContext context, Expression select, Expression value) {
        super(context);
        this.select = select;
        this.value = value;
        this.triggers = new Int2ObjectHashMap(10);
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public int returnsType() {
        return 10;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.select.resetState(postOptimization);
        if (this.value != null) {
            this.value.resetState(postOptimization);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.select.accept(visitor);
        if (this.value != null) {
            this.value.accept(visitor);
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        contextInfo.addFlag(8);
        this.select.analyze(contextInfo);
        if (this.value != null) {
            this.value.analyze(contextInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoredNode[] selectAndLock(Txn transaction, Sequence nodes) throws LockException, PermissionDeniedException, XPathException, TriggerException {
        Lock globalLock = this.context.getBroker().getBrokerPool().getGlobalUpdateLock();
        globalLock.lock();
        try {
            this.lockedDocuments = nodes.getDocumentSet();
            this.lockedDocuments.lock(this.context.getBroker(), true);
            StoredNode[] ql = new StoredNode[nodes.getItemCount()];
            for (int i = 0; i < ql.length; ++i) {
                Item item = nodes.itemAt(i);
                if (!Type.subTypeOf(item.getType(), -1)) {
                    throw new XPathException((Expression)this, "XQuery update expressions can only be applied to nodes. Got: " + item.getStringValue());
                }
                NodeValue nv = (NodeValue)item;
                if (nv.getImplementationType() == 0) {
                    throw new XPathException((Expression)this, "XQuery update expressions can not be applied to in-memory nodes.");
                }
                Node n = nv.getNode();
                if (n.getNodeType() == 9) {
                    throw new XPathException((Expression)this, "Updating the document object is not allowed.");
                }
                ql[i] = (StoredNode)n;
                DocumentImpl doc = ql[i].getOwnerDocument();
                this.prepareTrigger(transaction, doc);
            }
            StoredNode[] storedNodeArray = ql;
            return storedNodeArray;
        }
        finally {
            globalLock.unlock();
        }
    }

    protected Sequence deepCopy(Sequence inSeq) throws XPathException {
        this.context.pushDocumentContext();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.setReceiver(receiver);
        try {
            ValueSequence out = new ValueSequence();
            SequenceIterator i = inSeq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                if (item.getType() == 6) {
                    if (((NodeValue)item).getImplementationType() == 1) {
                        NodeHandle root = (NodeHandle)((Object)((NodeProxy)item).getOwnerDocument().getDocumentElement());
                        item = new NodeProxy(root);
                    } else {
                        item = (Item)((Object)((NodeValue)item).getOwnerDocument().getDocumentElement());
                    }
                }
                if (Type.subTypeOf(item.getType(), -1)) {
                    if (((NodeValue)item).getImplementationType() == 1) {
                        int last = builder.getDocument().getLastNode();
                        NodeProxy p = (NodeProxy)item;
                        serializer.toReceiver(p, false, false);
                        item = p.getNodeType() == 2 ? builder.getDocument().getLastAttr() : builder.getDocument().getNode(last + 1);
                    } else {
                        ((NodeImpl)item).deepCopy();
                    }
                }
                out.add(item);
            }
            ValueSequence valueSequence = out;
            return valueSequence;
        }
        catch (DOMException | SAXException e) {
            throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
        }
        finally {
            this.context.popDocumentContext();
        }
    }

    protected void finishTriggers(Txn transaction) throws TriggerException {
        Iterator<DocumentImpl> iterator = this.modifiedDocuments.getDocumentIterator();
        while (iterator.hasNext()) {
            DocumentImpl doc = iterator.next();
            this.context.addModifiedDoc(doc);
            this.finishTrigger(transaction, doc);
        }
        this.triggers.clear();
    }

    protected void unlockDocuments() {
        if (this.lockedDocuments == null) {
            return;
        }
        this.modifiedDocuments.clear();
        this.lockedDocuments.unlock();
        this.lockedDocuments = null;
    }

    public static void checkFragmentation(XQueryContext context, DocumentSet docs) throws EXistException {
        int fragmentationLimit = -1;
        Object property = context.getBroker().getBrokerPool().getConfiguration().getProperty("xupdate.fragmentation");
        if (property != null) {
            fragmentationLimit = (Integer)property;
        }
        Modification.checkFragmentation(context, docs, fragmentationLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkFragmentation(XQueryContext context, DocumentSet docs, int splitCount) throws EXistException {
        DBBroker broker = context.getBroker();
        try (Txn transaction = broker.getBrokerPool().getTransactionManager().beginTransaction();){
            Iterator<DocumentImpl> i = docs.getDocumentIterator();
            while (i.hasNext()) {
                DocumentImpl next = i.next();
                if (next.getMetadata().getSplitCount() > splitCount) {
                    org.exist.storage.lock.Lock lock = next.getUpdateLock();
                    try {
                        lock.acquire(Lock.LockMode.WRITE_LOCK);
                        broker.defragXMLResource(transaction, next);
                    }
                    finally {
                        lock.release(Lock.LockMode.WRITE_LOCK);
                    }
                }
                broker.checkXMLResourceConsistency(next);
            }
            transaction.commit();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    private void prepareTrigger(Txn transaction, DocumentImpl doc) throws TriggerException {
        Collection col = doc.getCollection();
        DBBroker broker = this.context.getBroker();
        DocumentTriggers trigger = new DocumentTriggers(broker, col);
        trigger.beforeUpdateDocument(this.context.getBroker(), transaction, doc);
        this.triggers.put(doc.getDocId(), trigger);
    }

    private void finishTrigger(Txn transaction, DocumentImpl doc) throws TriggerException {
        DocumentTrigger trigger = this.triggers.get(doc.getDocId());
        if (trigger != null) {
            trigger.afterUpdateDocument(this.context.getBroker(), transaction, doc);
        }
    }

    protected Txn getTransaction() {
        return this.context.getBroker().getBrokerPool().getTransactionManager().beginTransaction();
    }
}

