/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.TextImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Replace
extends Modification {
    public Replace(XQueryContext context, Expression select, Expression value) {
        super(context, select, value);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence contentSeq;
        Sequence inSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((inSeq = this.select.eval(contextSequence)).isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (!Type.subTypeOf(inSeq.getItemType(), -1)) {
            ValueSequence prevUpdateErrors = null;
            XPathException xpe = new XPathException((Expression)this, Messages.getMessage("D08"));
            Object ctxVarObj = this.context.getXQueryContextVar("_eXist_xquery_update_error");
            prevUpdateErrors = ctxVarObj == null ? new ValueSequence() : (ValueSequence)XPathUtil.javaObjectToXPath(ctxVarObj, this.context);
            prevUpdateErrors.add(new StringValue(xpe.getMessage()));
            this.context.setXQueryContextVar("_eXist_xquery_update_error", prevUpdateErrors);
            if (!inSeq.isEmpty()) {
                throw xpe;
            }
        }
        if ((contentSeq = this.value.eval(contextSequence)).isEmpty()) {
            throw new XPathException((Expression)this, Messages.getMessage("D09"));
        }
        this.context.pushInScopeNamespaces();
        contentSeq = this.deepCopy(contentSeq);
        try (Txn transaction = this.getTransaction();){
            StoredNode[] ql = this.selectAndLock(transaction, inSeq);
            NotificationService notifier = this.context.getBroker().getBrokerPool().getNotificationService();
            for (StoredNode node : ql) {
                DocumentImpl doc = node.getOwnerDocument();
                if (!doc.getPermissions().validate(this.context.getSubject(), 2)) {
                    throw new PermissionDeniedException("User '" + this.context.getSubject().getName() + "' does not have permission to write to the document '" + doc.getDocumentURI() + "'!");
                }
                ElementImpl parent = (ElementImpl)node.getParentStoredNode();
                if (parent == null) {
                    throw new XPathException((Expression)this, "The root element of a document can not be replaced with 'update replace'. Please consider removing the document or use 'update value' to just replace the children of the root.");
                }
                switch (node.getNodeType()) {
                    case 1: {
                        Item temp = contentSeq.itemAt(0);
                        if (!Type.subTypeOf(temp.getType(), -1)) {
                            throw new XPathException((Expression)this, Messages.getMessage("D10", Type.getTypeName(temp.getType())));
                        }
                        parent.replaceChild(transaction, ((NodeValue)temp).getNode(), node);
                        break;
                    }
                    case 3: {
                        TextImpl text = new TextImpl(contentSeq.getStringValue());
                        text.setOwnerDocument(doc);
                        parent.updateChild(transaction, node, text);
                        break;
                    }
                    case 2: {
                        AttrImpl attr = (AttrImpl)node;
                        AttrImpl attribute = new AttrImpl(attr.getQName(), contentSeq.getStringValue(), this.context.getBroker().getBrokerPool().getSymbols());
                        attribute.setOwnerDocument(doc);
                        parent.updateChild(transaction, node, attribute);
                        break;
                    }
                    default: {
                        throw new EXistException("unsupported node-type");
                    }
                }
                doc.getMetadata().setLastModified(System.currentTimeMillis());
                this.modifiedDocuments.add(doc);
                this.context.getBroker().storeXMLResource(transaction, doc);
                notifier.notifyUpdate(doc, 1);
            }
            this.finishTriggers(transaction);
            transaction.commit();
        }
        catch (EXistException | TriggerException | PermissionDeniedException | LockException e) {
            throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
        }
        finally {
            this.unlockDocuments();
            this.context.popInScopeNamespaces();
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("update replace").nl();
        dumper.startIndent();
        this.select.dump(dumper);
        dumper.nl().endIndent().display("with").nl().startIndent();
        this.value.dump(dumper);
        dumper.nl().endIndent();
    }

    public String toString() {
        return "update replace " + this.select.toString() + " with " + this.value.toString();
    }
}

