/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.NodeListImpl;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.TextImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Attr;

public class Update
extends Modification {
    private static final Logger LOG = LogManager.getLogger(Update.class);

    public Update(XQueryContext context, Expression select, Expression value) {
        super(context, select, value);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence contentSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((contentSeq = this.value.eval(contextSequence)).isEmpty()) {
            throw new XPathException((Expression)this, Messages.getMessage("D09"));
        }
        Sequence inSeq = this.select.eval(contextSequence);
        if (!Type.subTypeOf(inSeq.getItemType(), -1)) {
            ValueSequence prevUpdateErrors = null;
            XPathException xpe = new XPathException((Expression)this, Messages.getMessage("D08"));
            Object ctxVarObj = this.context.getXQueryContextVar("_eXist_xquery_update_error");
            prevUpdateErrors = ctxVarObj == null ? new ValueSequence() : (ValueSequence)XPathUtil.javaObjectToXPath(ctxVarObj, this.context);
            prevUpdateErrors.add(new StringValue(xpe.getMessage()));
            this.context.setXQueryContextVar("_eXist_xquery_update_error", prevUpdateErrors);
            if (!inSeq.isEmpty()) {
                throw xpe;
            }
        }
        if (!inSeq.isEmpty()) {
            this.context.pushInScopeNamespaces();
            try (Txn transaction = this.getTransaction();){
                StoredNode[] ql;
                NotificationService notifier = this.context.getBroker().getBrokerPool().getNotificationService();
                for (StoredNode node : ql = this.selectAndLock(transaction, inSeq)) {
                    DocumentImpl doc = node.getOwnerDocument();
                    if (!doc.getPermissions().validate(this.context.getSubject(), 2)) {
                        throw new XPathException((Expression)this, "User '" + this.context.getSubject().getName() + "' does not have permission to write to the document '" + doc.getDocumentURI() + "'!");
                    }
                    switch (node.getNodeType()) {
                        case 1: {
                            TextImpl text;
                            NodeListImpl content = new NodeListImpl();
                            SequenceIterator j = contentSeq.iterate();
                            while (j.hasNext()) {
                                Item next = j.nextItem();
                                if (Type.subTypeOf(next.getType(), -1)) {
                                    content.add(((NodeValue)next).getNode());
                                    continue;
                                }
                                text = new TextImpl(next.getStringValue());
                                content.add(text);
                            }
                            ((ElementImpl)node).update(transaction, content);
                            break;
                        }
                        case 3: {
                            ElementImpl parent = (ElementImpl)node.getParentNode();
                            TextImpl text = new TextImpl(contentSeq.getStringValue());
                            text.setOwnerDocument(doc);
                            parent.updateChild(transaction, node, text);
                            break;
                        }
                        case 2: {
                            ElementImpl parent = (ElementImpl)((Attr)((Object)node)).getOwnerElement();
                            if (parent == null) {
                                LOG.warn("parent node not found for " + node.getNodeId());
                                break;
                            }
                            AttrImpl attr = (AttrImpl)node;
                            AttrImpl attribute = new AttrImpl(attr.getQName(), contentSeq.getStringValue(), this.context.getBroker().getBrokerPool().getSymbols());
                            attribute.setOwnerDocument(doc);
                            parent.updateChild(transaction, node, attribute);
                            break;
                        }
                        default: {
                            throw new XPathException((Expression)this, "unsupported node-type");
                        }
                    }
                    doc.getMetadata().setLastModified(System.currentTimeMillis());
                    this.modifiedDocuments.add(doc);
                    this.context.getBroker().storeXMLResource(transaction, doc);
                    notifier.notifyUpdate(doc, 1);
                }
                this.finishTriggers(transaction);
                transaction.commit();
            }
            catch (EXistException | TriggerException | PermissionDeniedException | LockException e) {
                throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
            }
            finally {
                this.unlockDocuments();
                this.context.popInScopeNamespaces();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("update value").nl();
        dumper.startIndent();
        this.select.dump(dumper);
        dumper.nl().endIndent().display("with").nl().startIndent();
        this.value.dump(dumper);
        dumper.nl().endIndent();
    }

    public String toString() {
        return "update value" + this.select.toString() + " with " + this.value.toString();
    }
}

