/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.exist.xquery.Expression;

public class ExpressionDumper {
    public static final int DEFAULT_INDENT_AMOUNT = 4;
    private PrintWriter out;
    private int indentAmount;
    private String spaces;
    private int verbosity;
    private int indent = 0;

    public static String dump(Expression expr) {
        if (expr == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        ExpressionDumper dumper = new ExpressionDumper(writer);
        expr.dump(dumper);
        return writer.toString();
    }

    public ExpressionDumper(Writer writer) {
        this(writer, 4, 0);
    }

    public ExpressionDumper(Writer writer, int indentAmount) {
        this(writer, indentAmount, 0);
    }

    public ExpressionDumper(Writer writer, int indentAmount, int verbosity) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.indentAmount = indentAmount;
        this.spaces = "";
        for (int i = 0; i < indentAmount; ++i) {
            this.spaces = this.spaces + " ";
        }
        this.verbosity = verbosity;
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(this.spaces);
        }
    }

    public int verbosity() {
        return this.verbosity;
    }

    public ExpressionDumper display(Object object) {
        return this.display(object.toString());
    }

    public ExpressionDumper display(String s) {
        this.out.print(s);
        return this;
    }

    public ExpressionDumper display(String s, int line) {
        this.out.print(s);
        this.out.print(' ');
        if (line > -1) {
            this.out.print('<');
            this.out.print(line);
            this.out.print("> ");
        }
        return this;
    }

    public ExpressionDumper display(char ch) {
        this.out.print(ch);
        return this;
    }

    public ExpressionDumper startIndent() {
        ++this.indent;
        this.nl();
        return this;
    }

    public ExpressionDumper endIndent() {
        if (this.indent > 0) {
            --this.indent;
        }
        return this;
    }

    public ExpressionDumper nl() {
        this.out.println();
        this.indent();
        return this;
    }
}

