/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.util;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.Variable;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;

public class HTTPUtils {
    private static final Logger LOG = LogManager.getLogger(XQuery.class);

    public static void addLastModifiedHeader(Sequence result, XQueryContext context) {
        try {
            DocumentSet documentSet = result.getDocumentSet();
            long mostRecentDocumentTime = 0L;
            Iterator<DocumentImpl> i = documentSet.getDocumentIterator();
            while (i.hasNext()) {
                DocumentImpl doc = i.next();
                if (doc == null) continue;
                mostRecentDocumentTime = Math.max(doc.getMetadata().getLastModified(), mostRecentDocumentTime);
            }
            LOG.debug("mostRecentDocumentTime: " + mostRecentDocumentTime);
            if (mostRecentDocumentTime > 0L) {
                ResponseWrapper responseWrapper;
                JavaObjectValue value;
                ResponseModule myModule = (ResponseModule)context.getModule("http://exist-db.org/xquery/response");
                if (myModule == null) {
                    return;
                }
                Variable var = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
                if (var != null && var.getValue() != null && (value = (JavaObjectValue)var.getValue().itemAt(0)) != null && value.getObject() instanceof ResponseWrapper && (responseWrapper = (ResponseWrapper)value.getObject()).getDateHeader("Last-Modified") == 0L) {
                    responseWrapper.setDateHeader("Last-Modified", mostRecentDocumentTime);
                }
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static String printStackTraceHTML(Throwable e) {
        StringBuilder buf = new StringBuilder();
        StackTraceElement[] trace = e.getStackTrace();
        buf.append("<table id=\"javatrace\">");
        buf.append("<caption>Java Stack Trace:</caption>");
        buf.append("<tr><th>Class Name</th><th>Method Name</th><th>File Name</th><th>Line</th></tr>");
        for (int i = 0; i < trace.length && i < 20; ++i) {
            buf.append("<tr>");
            buf.append("<td class=\"class\">").append(trace[i].getClassName()).append("</td>");
            buf.append("<td class=\"method\">").append(trace[i].getMethodName()).append("</td>");
            buf.append("<td class=\"file\">").append(trace[i].getFileName() == null ? "Unknown" : trace[i].getFileName()).append("</td>");
            buf.append("<td class=\"line\">");
            buf.append(trace[i].getLineNumber() < 0 ? "Unavailable" : Integer.toString(trace[i].getLineNumber()));
            buf.append("</td>");
            buf.append("</tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }
}

