/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.util.io.Base64OutputStream;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.BinaryValueType;

public class Base64BinaryValueType
extends BinaryValueType<Base64OutputStream> {
    private static final Pattern base64Pattern = Pattern.compile("^((?>(?>\\s*[A-Za-z0-9+/]){4})*(?>(?>\\s*[A-Za-z0-9+/]){1}(?>\\s*[AQgw]){1}\\s*=\\s*=|(?>\\s*[A-Za-z0-9+/]){3}\\s*=)?)$");

    public Base64BinaryValueType() {
        super(26, Base64OutputStream.class);
    }

    private Matcher getMatcher(String toMatch) {
        return base64Pattern.matcher(toMatch);
    }

    @Override
    public void verifyString(String str) throws XPathException {
        if (!this.getMatcher(str).matches()) {
            throw new XPathException("FORG0001: Invalid base64 data");
        }
    }

    @Override
    protected String formatString(String str) {
        return str;
    }
}

