/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.io.CachingFilterInputStream;
import org.exist.util.io.FilterInputStreamCache;
import org.exist.util.io.FilterInputStreamCacheFactory;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;

public class BinaryValueFromInputStream
extends BinaryValue {
    private static final Logger LOG = LogManager.getLogger(BinaryValueFromInputStream.class);
    private final CachingFilterInputStream is;
    private final FilterInputStreamCache cache;

    protected BinaryValueFromInputStream(BinaryValueManager manager, BinaryValueType binaryValueType, InputStream is) throws XPathException {
        super(manager, binaryValueType);
        try {
            this.cache = FilterInputStreamCacheFactory.getCacheInstance(manager::getCacheClass, is);
            this.is = new CachingFilterInputStream(this.cache);
        }
        catch (IOException ioe) {
            throw new XPathException(ioe);
        }
        this.is.mark(Integer.MAX_VALUE);
    }

    public static BinaryValueFromInputStream getInstance(BinaryValueManager manager, BinaryValueType binaryValueType, InputStream is) throws XPathException {
        BinaryValueFromInputStream binaryInputStream = new BinaryValueFromInputStream(manager, binaryValueType, is);
        manager.registerBinaryValueInstance(binaryInputStream);
        return binaryInputStream;
    }

    @Override
    public BinaryValue convertTo(BinaryValueType binaryValueType) throws XPathException {
        try {
            BinaryValueFromInputStream binaryInputStream = new BinaryValueFromInputStream(this.getManager(), binaryValueType, new CachingFilterInputStream(this.is));
            this.getManager().registerBinaryValueInstance(binaryInputStream);
            return binaryInputStream;
        }
        catch (InstantiationException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamBinaryTo(OutputStream os) throws IOException {
        try {
            int read = -1;
            byte[] data = new byte[4096];
            while ((read = this.is.read(data)) > -1) {
                os.write(data, 0, read);
            }
        }
        finally {
            try {
                this.is.reset();
            }
            catch (IOException ioe) {
                LOG.error("Unable to reset stream: {}", (Object)ioe.getMessage(), (Object)ioe);
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new CachingFilterInputStream(this.is);
        }
        catch (InstantiationException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.is.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void destroy(XQueryContext context, Sequence contextSequence) {
        if (contextSequence == this || contextSequence instanceof ValueSequence && ((ValueSequence)contextSequence).containsValue(this)) {
            return;
        }
        LOG.debug("Closing input stream");
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.warn("Error during cleanup of binary value: {}", (Object)e.getMessage(), (Object)e);
        }
        context.destroyBinaryValue(this);
    }

    @Override
    public void incrementSharedReferences() {
        this.cache.incrementSharedReferences();
    }
}

