/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.exist.util.FastStringBuffer;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class DecimalValue
extends NumericValue {
    public static final BigInteger BIG_INTEGER_TEN = BigInteger.valueOf(10L);
    private static final BigDecimal ZERO_BIGDECIMAL = new BigDecimal("0");
    private static final int DIVIDE_PRECISION = 18;
    private static final Pattern decimalPattern = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static boolean stripTrailingZerosMethodUnavailable = false;
    private static Method stripTrailingZerosMethod = null;
    BigDecimal value;

    public DecimalValue(BigDecimal decimal) {
        this.value = DecimalValue.stripTrailingZeros(decimal);
    }

    public DecimalValue(String str) throws XPathException {
        str = StringValue.trimWhitespace(str);
        try {
            if (!decimalPattern.matcher(str).matches()) {
                throw new XPathException(ErrorCodes.FORG0001, "cannot construct " + Type.getTypeName(this.getItemType()) + " from \"" + str + "\"");
            }
            this.value = DecimalValue.stripTrailingZeros(new BigDecimal(str));
        }
        catch (NumberFormatException e) {
            throw new XPathException(ErrorCodes.FORG0001, "cannot construct " + Type.getTypeName(this.getItemType()) + " from \"" + this.getStringValue() + "\"");
        }
    }

    public DecimalValue(double doubleValue) {
        this.value = DecimalValue.stripTrailingZeros(new BigDecimal(doubleValue));
    }

    private static BigDecimal stripTrailingZeros(BigDecimal value) {
        if (stripTrailingZerosMethodUnavailable) {
            return DecimalValue.stripTrailingZerosFallback(value);
        }
        try {
            if (stripTrailingZerosMethod == null) {
                Class[] argTypes = new Class[]{};
                stripTrailingZerosMethod = BigDecimal.class.getMethod("stripTrailingZeros", argTypes);
            }
            Object result = stripTrailingZerosMethod.invoke((Object)value, EMPTY_OBJECT_ARRAY);
            return (BigDecimal)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(value);
        }
    }

    private static BigDecimal stripTrailingZerosFallback(BigDecimal value) {
        int scale = value.scale();
        if (scale > 0) {
            BigInteger[] dr;
            BigInteger i = value.unscaledValue();
            while ((dr = i.divideAndRemainder(BIG_INTEGER_TEN))[1].equals(BigInteger.ZERO)) {
                i = dr[0];
                if (--scale != 0) continue;
                break;
            }
            if (scale != value.scale()) {
                value = new BigDecimal(i, scale);
            }
        }
        return value;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public String getStringValue() throws XPathException {
        int scale = this.value.scale();
        if (scale == 0) {
            return this.value.toString();
        }
        if (scale < 0) {
            String s = this.value.abs().unscaledValue().toString();
            FastStringBuffer sb = new FastStringBuffer(s.length() + -scale + 2);
            if (this.value.signum() < 0) {
                sb.append('-');
            }
            sb.append(s);
            if (!"0".equals(s)) {
                for (int i = 0; i < -scale; ++i) {
                    sb.append('0');
                }
            }
            return sb.toString();
        }
        String s = this.value.abs().unscaledValue().toString();
        if ("0".equals(s)) {
            return s;
        }
        int len = s.length();
        FastStringBuffer sb = new FastStringBuffer(len + 1);
        if (this.value.signum() < 0) {
            sb.append('-');
        }
        if (scale >= len) {
            sb.append("0.");
            for (int i = len; i < scale; ++i) {
                sb.append('0');
            }
            sb.append(s);
        } else {
            sb.append(s.substring(0, len - scale));
            sb.append('.');
            sb.append(s.substring(len - scale));
        }
        return sb.toString();
    }

    @Override
    public boolean hasFractionalPart() {
        return this.value.scale() > 0;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 30: 
            case 32: {
                return this;
            }
            case 34: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 33: {
                return new FloatValue(this.value.floatValue());
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue(this.value.longValue(), requiredType);
            }
            case 23: {
                return this.value.signum() == 0 ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
        }
        throw new XPathException(ErrorCodes.FORG0001, "cannot convert  '" + Type.getTypeName(this.getType()) + " (" + this.value + ")' into " + Type.getTypeName(requiredType));
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean isZero() {
        return this.value.signum() == 0;
    }

    @Override
    public boolean isNegative() {
        return this.value.signum() < 0;
    }

    @Override
    public boolean isPositive() {
        return this.value.signum() > 0;
    }

    @Override
    public NumericValue negate() throws XPathException {
        return new DecimalValue(this.value.negate());
    }

    @Override
    public NumericValue ceiling() throws XPathException {
        return new DecimalValue(this.value.setScale(0, 2));
    }

    @Override
    public NumericValue floor() throws XPathException {
        return new DecimalValue(this.value.setScale(0, 3));
    }

    @Override
    public NumericValue round() throws XPathException {
        switch (this.value.signum()) {
            case -1: {
                return new DecimalValue(this.value.setScale(0, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new DecimalValue(this.value.setScale(0, 4));
            }
        }
        return this;
    }

    @Override
    public NumericValue round(IntegerValue precision) throws XPathException {
        if (this.value.signum() == 0) {
            return this;
        }
        int pre = precision == null ? 0 : precision.getInt();
        if (pre >= 0) {
            return new DecimalValue(this.value.setScale(pre, 6));
        }
        return new DecimalValue(this.value.movePointRight(pre).setScale(0, 6).movePointLeft(pre));
    }

    @Override
    public ComputableValue minus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 32: {
                return new DecimalValue(this.value.subtract(((DecimalValue)other).value));
            }
            case 31: {
                return this.minus((ComputableValue)other.convertTo(this.getType()));
            }
        }
        return ((ComputableValue)this.convertTo(other.getType())).minus(other);
    }

    @Override
    public ComputableValue plus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 32: {
                return new DecimalValue(this.value.add(((DecimalValue)other).value));
            }
            case 31: {
                return this.plus((ComputableValue)other.convertTo(this.getType()));
            }
        }
        return ((ComputableValue)this.convertTo(other.getType())).plus(other);
    }

    @Override
    public ComputableValue mult(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 32: {
                return new DecimalValue(this.value.multiply(((DecimalValue)other).value));
            }
            case 31: {
                return this.mult((ComputableValue)other.convertTo(this.getType()));
            }
            case 54: 
            case 55: {
                return other.mult(this);
            }
        }
        return ((ComputableValue)this.convertTo(other.getType())).mult(other);
    }

    @Override
    public ComputableValue div(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 31: {
                return this.div((ComputableValue)other.convertTo(this.getType()));
            }
        }
        if (!(other instanceof DecimalValue)) {
            ComputableValue n = (ComputableValue)this.convertTo(other.getType());
            return n.div(other);
        }
        if (((DecimalValue)other).isZero()) {
            throw new XPathException(ErrorCodes.FOAR0001, "division by zero");
        }
        int scale = Math.max(18, Math.max(this.value.scale(), ((DecimalValue)other).value.scale()));
        BigDecimal result = this.value.divide(((DecimalValue)other).value, scale, 5);
        return new DecimalValue(result);
    }

    @Override
    public IntegerValue idiv(NumericValue other) throws XPathException {
        if (other.isZero()) {
            throw new XPathException(ErrorCodes.FOAR0001, "division by zero");
        }
        DecimalValue dv = (DecimalValue)other.convertTo(32);
        BigInteger quot = this.value.divide(dv.value, 0, 1).toBigInteger();
        return new IntegerValue(quot);
    }

    @Override
    public NumericValue mod(NumericValue other) throws XPathException {
        if (other.getType() == 32) {
            if (other.isZero()) {
                throw new XPathException(ErrorCodes.FOAR0001, "division by zero");
            }
            BigDecimal quotient = this.value.divide(((DecimalValue)other).value, 0, 1);
            BigDecimal remainder = this.value.subtract(quotient.setScale(0, 1).multiply(((DecimalValue)other).value));
            return new DecimalValue(remainder);
        }
        return ((NumericValue)this.convertTo(other.getType())).mod(other);
    }

    @Override
    public NumericValue abs() throws XPathException {
        return new DecimalValue(this.value.abs());
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 32) {
            return new DecimalValue(this.value.max(((DecimalValue)other).value));
        }
        return new DecimalValue(this.value.max(((DecimalValue)other.convertTo((int)32)).value));
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 32) {
            return new DecimalValue(this.value.min(((DecimalValue)other).value));
        }
        return new DecimalValue(this.value.min(((DecimalValue)other.convertTo((int)32)).value));
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        if (other.isEmpty()) {
            return false;
        }
        if (Type.subTypeOf(other.getType(), 30)) {
            if (this.isNaN() && ((NumericValue)other).isNaN()) {
                return operator == Constants.Comparison.NEQ;
            }
            if (Type.subTypeOf(other.getType(), 32)) {
                DecimalValue otherValue = (DecimalValue)other.convertTo(32);
                switch (operator) {
                    case EQ: {
                        return this.compareTo(otherValue) == 0;
                    }
                    case NEQ: {
                        return this.compareTo(otherValue) != 0;
                    }
                    case GT: {
                        return this.compareTo(otherValue) == 1;
                    }
                    case GTEQ: {
                        return this.compareTo(otherValue) != -1;
                    }
                    case LT: {
                        return this.compareTo(otherValue) == -1;
                    }
                    case LTEQ: {
                        return this.compareTo(otherValue) != 1;
                    }
                }
                throw new XPathException("Type error: cannot apply operator to numeric value");
            }
        }
        return super.compareTo(collator, operator, other);
    }

    @Override
    public int compareTo(Object o) {
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 32)) {
            DecimalValue otherAsDecimal = null;
            try {
                otherAsDecimal = (DecimalValue)other.convertTo(32);
            }
            catch (XPathException e) {
                return -1;
            }
            return this.value.compareTo(otherAsDecimal.value);
        }
        return this.getType() < other.getType() ? -1 : 1;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(DecimalValue.class)) {
            return 0;
        }
        if (javaClass == BigDecimal.class) {
            return 1;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 4;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 5;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 6;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 7;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 2;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 3;
        }
        if (javaClass == String.class) {
            return 8;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 9;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(DecimalValue.class)) {
            return (T)this;
        }
        if (target == BigDecimal.class) {
            return (T)this.value;
        }
        if (target == Double.class || target == Double.TYPE) {
            return (T)Double.valueOf(this.value.doubleValue());
        }
        if (target == Float.class || target == Float.TYPE) {
            return (T)Float.valueOf(this.value.floatValue());
        }
        if (target == Long.class || target == Long.TYPE) {
            return (T)Long.valueOf(((IntegerValue)this.convertTo(37)).getValue());
        }
        if (target == Integer.class || target == Integer.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return (T)Integer.valueOf((int)v.getValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return (T)Short.valueOf((short)v.getValue());
        }
        if (target == Byte.class || target == Byte.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return (T)Byte.valueOf((byte)v.getValue());
        }
        if (target == String.class) {
            return (T)this.getStringValue();
        }
        if (target == Boolean.class) {
            return (T)Boolean.valueOf(this.effectiveBooleanValue());
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

