/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.util.io.HexOutputStream;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.BinaryValueType;

public class HexBinaryValueType
extends BinaryValueType<HexOutputStream> {
    private static final Pattern hexPattern = Pattern.compile("[A-Fa-f0-9]*");

    public HexBinaryValueType() {
        super(27, HexOutputStream.class);
    }

    private Matcher getMatcher(String toMatch) {
        return hexPattern.matcher(toMatch);
    }

    @Override
    protected void verifyString(String str) throws XPathException {
        if ((str.length() & 1) != 0) {
            throw new XPathException(ErrorCodes.FORG0001, "A hexBinary value must contain an even number of characters");
        }
        if (!this.getMatcher(str).matches()) {
            throw new XPathException(ErrorCodes.FORG0001, "Invalid hexadecimal digit");
        }
    }

    @Override
    protected String formatString(String str) {
        return str.toUpperCase(Locale.ENGLISH);
    }
}

