/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import org.exist.xquery.Constants;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Type;

public class JavaObjectValue
extends AtomicValue {
    private final Object object;

    public JavaObjectValue(Object object) {
        this.object = object;
    }

    @Override
    public int getType() {
        return 100;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.object);
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        if (requiredType == 100) {
            return this;
        }
        throw new XPathException("cannot convert Java object to " + Type.getTypeName(requiredType));
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("Called effectiveBooleanValue() on JavaObjectValue");
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        throw new XPathException("cannot compare Java object to " + Type.getTypeName(other.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("cannot compare Java object to " + Type.getTypeName(other.getType()));
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: cannot compare Java objects");
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: cannot compare Java objects");
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(this.object.getClass())) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(this.object.getClass())) {
            return (T)this.object;
        }
        if (target == Object.class) {
            return (T)this.object;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

