/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.Arrays;
import java.util.Comparator;
import org.exist.dom.persistent.ContextItem;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.Expression;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class PreorderedValueSequence
extends AbstractSequence {
    private final OrderSpec[] orderSpecs;
    private final OrderedNodeProxy[] nodes;

    public PreorderedValueSequence(OrderSpec[] specs, Sequence input, int contextId) throws XPathException {
        this.orderSpecs = specs;
        this.nodes = new OrderedNodeProxy[input.getItemCount()];
        int j = 0;
        SequenceIterator i = input.unorderedIterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.nextItem();
            this.nodes[j] = new OrderedNodeProxy(p);
            p.addContextNode(contextId, this.nodes[j]);
            ++j;
        }
        this.processAll();
    }

    private void processAll() throws XPathException {
        for (int i = 0; i < this.orderSpecs.length; ++i) {
            Expression expr = this.orderSpecs[i].getSortExpression();
            NodeSet result = expr.eval(null).toNodeSet();
            for (NodeProxy p : result) {
                for (ContextItem context = p.getContext(); context != null; context = context.getNextDirect()) {
                    if (!(context.getNode() instanceof OrderedNodeProxy)) continue;
                    OrderedNodeProxy cp = (OrderedNodeProxy)context.getNode();
                    cp.values[i] = p.atomize();
                }
            }
        }
    }

    @Override
    public void clearContext(int contextId) throws XPathException {
        for (OrderedNodeProxy node : this.nodes) {
            node.clearContext(contextId);
        }
    }

    @Override
    public int getItemType() {
        return -1;
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        this.sort();
        return new PreorderedValueSequenceIterator();
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        return new PreorderedValueSequenceIterator();
    }

    @Override
    public int getItemCount() {
        return this.nodes.length;
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.length == 0;
    }

    @Override
    public boolean hasOne() {
        return this.nodes.length == 1;
    }

    @Override
    public void add(Item item) throws XPathException {
    }

    @Override
    public Item itemAt(int pos) {
        return this.nodes[pos];
    }

    @Override
    public NodeSet toNodeSet() throws XPathException {
        return null;
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        return null;
    }

    @Override
    public void removeDuplicates() {
    }

    private void sort() {
        Arrays.sort(this.nodes, new OrderedComparator());
    }

    private class PreorderedValueSequenceIterator
    implements SequenceIterator {
        int pos = 0;

        private PreorderedValueSequenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < PreorderedValueSequence.this.nodes.length;
        }

        @Override
        public Item nextItem() {
            if (this.pos < PreorderedValueSequence.this.nodes.length) {
                return PreorderedValueSequence.this.nodes[this.pos++];
            }
            return null;
        }
    }

    private class OrderedNodeProxy
    extends NodeProxy {
        AtomicValue[] values;

        public OrderedNodeProxy(NodeProxy p) {
            super(p);
            this.values = new AtomicValue[PreorderedValueSequence.this.orderSpecs.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = AtomicValue.EMPTY_VALUE;
            }
        }
    }

    private class OrderedComparator
    implements Comparator<OrderedNodeProxy> {
        private OrderedComparator() {
        }

        @Override
        public int compare(OrderedNodeProxy p1, OrderedNodeProxy p2) {
            int cmp = 0;
            for (int i = 0; i < p1.values.length; ++i) {
                try {
                    AtomicValue a = p1.values[i];
                    AtomicValue b = p2.values[i];
                    cmp = a == AtomicValue.EMPTY_VALUE && b != AtomicValue.EMPTY_VALUE ? ((PreorderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? -1 : 1) : (a != AtomicValue.EMPTY_VALUE && b == AtomicValue.EMPTY_VALUE ? ((PreorderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? 1 : -1) : a.compareTo(PreorderedValueSequence.this.orderSpecs[i].getCollator(), b));
                    if ((PreorderedValueSequence.this.orderSpecs[i].getModifiers() & 1) != 0) {
                        cmp *= -1;
                    }
                    if (cmp == 0) continue;
                    break;
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
            return cmp;
        }
    }
}

