/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class QNameValue
extends AtomicValue {
    private final QName qname;
    private final String stringValue;

    public QNameValue(XQueryContext context, String name) throws XPathException {
        if (name.isEmpty()) {
            throw new XPathException(ErrorCodes.FORG0001, "An empty string is not a valid lexical representation of xs:QName.");
        }
        try {
            this.qname = QName.parse(context, name, context.getURIForPrefix(""));
        }
        catch (QName.IllegalQNameException iqe) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + name);
        }
        this.stringValue = this.computeStringValue();
    }

    public QNameValue(XQueryContext context, QName name) {
        this.qname = name;
        this.stringValue = this.computeStringValue();
    }

    @Override
    public int getType() {
        return 24;
    }

    public QName getQName() {
        return this.qname;
    }

    @Override
    public String getStringValue() throws XPathException {
        return this.stringValue;
    }

    private String computeStringValue() {
        String prefix = this.qname.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            return prefix + ':' + this.qname.getLocalPart();
        }
        return this.qname.getLocalPart();
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 24: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("A QName cannot be converted to " + Type.getTypeName(requiredType));
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        if (other.getType() == 24) {
            int cmp = this.qname.compareTo(((QNameValue)other).qname);
            switch (operator) {
                case EQ: {
                    return cmp == 0;
                }
                case NEQ: {
                    return cmp != 0;
                }
            }
            throw new XPathException(ErrorCodes.XPTY0004, "cannot apply operator to QName");
        }
        throw new XPathException(ErrorCodes.XPTY0004, "Type error: cannot compare QName to " + Type.getTypeName(other.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 24) {
            return this.qname.compareTo(((QNameValue)other).qname);
        }
        throw new XPathException("Type error: cannot compare QName to " + Type.getTypeName(other.getType()));
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: QName");
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: QName");
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(QNameValue.class)) {
            return 0;
        }
        if (javaClass == String.class) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(QNameValue.class)) {
            return (T)this;
        }
        if (target == String.class) {
            return (T)this.getStringValue();
        }
        if (target == Object.class) {
            return (T)this.qname;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    @Override
    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException e) {
            return super.toString();
        }
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException(ErrorCodes.FORG0006, "value of type " + Type.getTypeName(this.getType()) + " has no boolean value.");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QNameValue) {
            return ((QNameValue)obj).qname.equals(this.qname);
        }
        return false;
    }

    public int hashCode() {
        return this.qname.hashCode();
    }
}

