/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import org.exist.dom.QName;
import org.exist.xquery.Cardinality;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class SequenceType {
    private int primaryType = 11;
    private int cardinality = 2;
    private QName nodeName = null;

    public SequenceType() {
    }

    public SequenceType(int primaryType, int cardinality) {
        this.primaryType = primaryType;
        this.cardinality = cardinality;
    }

    public int getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(int type) {
        this.primaryType = type;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public QName getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(QName qname) {
        this.nodeName = qname;
    }

    public boolean checkType(Sequence seq) throws XPathException {
        if (this.nodeName != null) {
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (this.checkType(next)) continue;
                return false;
            }
            return true;
        }
        return Type.subTypeOf(seq.getItemType(), this.primaryType);
    }

    public boolean checkType(Item item) {
        Node realNode = null;
        int type = item.getType();
        if (type == -1) {
            realNode = ((NodeValue)item).getNode();
            type = realNode.getNodeType();
        }
        if (!Type.subTypeOf(type, this.primaryType)) {
            return false;
        }
        if (this.nodeName != null) {
            QName realName = ((NodeValue)item).getQName();
            if (this.nodeName.getNamespaceURI() != null && !this.nodeName.getNamespaceURI().equals(realName.getNamespaceURI())) {
                return false;
            }
            if (this.nodeName.getLocalPart() != null) {
                return this.nodeName.getLocalPart().equals(realName.getLocalPart());
            }
        }
        return true;
    }

    public void checkType(int type) throws XPathException {
        if (type == 10 || type == 11) {
            return;
        }
        if (type == 25 && this.primaryType == 22) {
            return;
        }
        if (!Type.subTypeOf(type, this.primaryType)) {
            throw new XPathException("Type error: expected type: " + Type.getTypeName(this.primaryType) + "; got: " + Type.getTypeName(type));
        }
    }

    public void checkCardinality(Sequence seq) throws XPathException {
        if (!seq.isEmpty() && this.cardinality == 1) {
            throw new XPathException("Empty sequence expected; got " + seq.getItemCount());
        }
        if (seq.isEmpty() && (this.cardinality & 1) == 0) {
            throw new XPathException("Empty sequence is not allowed here");
        }
        if (seq.hasMany() && (this.cardinality & 4) == 0) {
            throw new XPathException("Sequence with more than one item is not allowed here");
        }
    }

    public String toString() {
        if (this.cardinality == 1) {
            return Cardinality.toString(this.cardinality);
        }
        return Type.getTypeName(this.primaryType) + Cardinality.toString(this.cardinality);
    }
}

