/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class TimeUtils {
    private static final TimeUtils INSTANCE = new TimeUtils();
    public static final Duration ONE_DAY = TimeUtils.INSTANCE.factory.newDuration(true, 0, 0, 1, 0, 0, 0);
    private final DatatypeFactory factory;
    private int timezoneOffset;
    private boolean timezoneOverriden;

    private TimeUtils() {
        try {
            this.factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("unable to instantiate an XML datatype factory", e);
        }
    }

    public static TimeUtils getInstance() {
        return INSTANCE;
    }

    public DatatypeFactory getFactory() {
        return this.factory;
    }

    public void overrideLocalTimezoneOffset(int millis) {
        this.timezoneOffset = millis;
        this.timezoneOverriden = true;
    }

    public void resetLocalTimezoneOffset() {
        this.timezoneOverriden = false;
    }

    public int getLocalTimezoneOffsetMillis() {
        int dstOffset = Calendar.getInstance(TimeZone.getDefault()).get(16);
        return this.timezoneOverriden ? this.timezoneOffset : TimeZone.getDefault().getRawOffset() + dstOffset;
    }

    public int getLocalTimezoneOffsetMinutes() {
        return this.getLocalTimezoneOffsetMillis() / 60000;
    }

    public Duration newDuration(long arg0) {
        return this.factory.newDuration(arg0);
    }

    public Duration newDuration(String arg0) {
        return this.factory.newDuration(arg0);
    }

    public Duration newDuration(boolean isPositive, int years, int months, int days, int hours, int minutes, int seconds) {
        return this.factory.newDuration(isPositive, years, months, days, hours, minutes, seconds);
    }

    public Duration newDuration(boolean arg0, BigInteger arg1, BigInteger arg2, BigInteger arg3, BigInteger arg4, BigInteger arg5, BigDecimal arg6) {
        return this.factory.newDuration(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public Duration newDurationDayTime(long arg0) {
        return this.factory.newDurationDayTime(arg0);
    }

    public Duration newDurationDayTime(String arg0) {
        return this.factory.newDurationDayTime(arg0);
    }

    public Duration newDurationDayTime(boolean arg0, int arg1, int arg2, int arg3, int arg4) {
        return this.factory.newDurationDayTime(arg0, arg1, arg2, arg3, arg4);
    }

    public Duration newDurationDayTime(boolean arg0, BigInteger arg1, BigInteger arg2, BigInteger arg3, BigInteger arg4) {
        return this.factory.newDurationDayTime(arg0, arg1, arg2, arg3, arg4);
    }

    public Duration newDurationYearMonth(long arg0) {
        return this.factory.newDurationYearMonth(arg0);
    }

    public Duration newDurationYearMonth(String arg0) {
        return this.factory.newDurationYearMonth(arg0);
    }

    public Duration newDurationYearMonth(boolean arg0, int arg1, int arg2) {
        return this.factory.newDurationYearMonth(arg0, arg1, arg2);
    }

    public Duration newDurationYearMonth(boolean arg0, BigInteger arg1, BigInteger arg2) {
        return this.factory.newDurationYearMonth(arg0, arg1, arg2);
    }

    public XMLGregorianCalendar newXMLGregorianCalendar() {
        return this.factory.newXMLGregorianCalendar();
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        return this.factory.newXMLGregorianCalendar(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(String lexicalRepresentation) {
        return this.factory.newXMLGregorianCalendar(lexicalRepresentation);
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(BigInteger arg0, int arg1, int arg2, int arg3, int arg4, int arg5, BigDecimal arg6, int arg7) {
        return this.factory.newXMLGregorianCalendar(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar arg0) {
        return this.factory.newXMLGregorianCalendar(arg0);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarDate(int arg0, int arg1, int arg2, int arg3) {
        return this.factory.newXMLGregorianCalendarDate(arg0, arg1, arg2, arg3);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int arg0, int arg1, int arg2, int arg3) {
        return this.factory.newXMLGregorianCalendarTime(arg0, arg1, arg2, arg3);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int arg0, int arg1, int arg2, int arg3, int arg4) {
        return this.factory.newXMLGregorianCalendarTime(arg0, arg1, arg2, arg3, arg4);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int arg0, int arg1, int arg2, BigDecimal arg3, int arg4) {
        return this.factory.newXMLGregorianCalendarTime(arg0, arg1, arg2, arg3, arg4);
    }
}

