/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import org.exist.util.Collations;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromBinaryString;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.GDayValue;
import org.exist.xquery.value.GMonthDayValue;
import org.exist.xquery.value.GMonthValue;
import org.exist.xquery.value.GYearMonthValue;
import org.exist.xquery.value.GYearValue;
import org.exist.xquery.value.HexBinaryValueType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.YearMonthDurationValue;

public class UntypedAtomicValue
extends AtomicValue {
    private final String value;

    public UntypedAtomicValue(String value) {
        this.value = value;
    }

    public static AtomicValue convertTo(String value, int requiredType) throws XPathException {
        return UntypedAtomicValue.convertTo(null, value, requiredType);
    }

    public static AtomicValue convertTo(UntypedAtomicValue strVal, String value, int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 21: {
                return strVal == null ? new UntypedAtomicValue(value) : strVal;
            }
            case 22: {
                return new StringValue(value);
            }
            case 25: {
                return new AnyURIValue(value);
            }
            case 23: {
                String trimmed = StringValue.trimWhitespace(value);
                if ("0".equals(trimmed) || "false".equals(trimmed)) {
                    return BooleanValue.FALSE;
                }
                if ("1".equals(trimmed) || "true".equals(trimmed)) {
                    return BooleanValue.TRUE;
                }
                throw new XPathException(ErrorCodes.FORG0001, "cannot cast '" + Type.getTypeName(20) + "(\"" + value + "\")' to " + Type.getTypeName(requiredType));
            }
            case 33: {
                return new FloatValue(value);
            }
            case 34: {
                return new DoubleValue(value);
            }
            case 30: {
                return new DoubleValue(value);
            }
            case 32: {
                return new DecimalValue(value);
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue(value, requiredType);
            }
            case 26: {
                return new BinaryValueFromBinaryString(new Base64BinaryValueType(), value);
            }
            case 27: {
                return new BinaryValueFromBinaryString(new HexBinaryValueType(), value);
            }
            case 50: {
                return new DateTimeValue(value);
            }
            case 52: {
                return new TimeValue(value);
            }
            case 51: {
                return new DateValue(value);
            }
            case 56: {
                return new GYearValue(value);
            }
            case 57: {
                return new GMonthValue(value);
            }
            case 58: {
                return new GDayValue(value);
            }
            case 59: {
                return new GYearMonthValue(value);
            }
            case 71: {
                return new GMonthDayValue(value);
            }
            case 53: {
                return new DurationValue(value);
            }
            case 54: {
                return new YearMonthDurationValue(value);
            }
            case 55: {
                DayTimeDurationValue dtdv = new DayTimeDurationValue(value);
                return new DayTimeDurationValue(dtdv.getCanonicalDuration());
            }
        }
        throw new XPathException(ErrorCodes.FORG0001, "cannot cast '" + Type.getTypeName(20) + "(\"" + value + "\")' to " + Type.getTypeName(requiredType));
    }

    @Override
    public int getType() {
        return 21;
    }

    @Override
    public String getStringValue() throws XPathException {
        return this.value;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        return UntypedAtomicValue.convertTo(this, this.value, requiredType);
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        if (other.isEmpty()) {
            return false;
        }
        if (Type.subTypeOf(other.getType(), 22) || Type.subTypeOf(other.getType(), 21)) {
            int cmp = Collations.compare(collator, this.value, other.getStringValue());
            switch (operator) {
                case EQ: {
                    return cmp == 0;
                }
                case NEQ: {
                    return cmp != 0;
                }
                case LT: {
                    return cmp < 0;
                }
                case LTEQ: {
                    return cmp <= 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GTEQ: {
                    return cmp >= 0;
                }
            }
            throw new XPathException("Type error: cannot apply operand to string value");
        }
        throw new XPathException("Type error: operands are not comparable; expected xdt:untypedAtomic; got " + Type.getTypeName(other.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        return Collations.compare(collator, this.value, other.getStringValue());
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 21)) {
            return Collations.compare(collator, this.value, ((UntypedAtomicValue)other).value) > 0 ? this : other;
        }
        return Collations.compare(collator, this.value, other.getStringValue()) > 0 ? this : other;
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 21)) {
            return Collations.compare(collator, this.value, ((UntypedAtomicValue)other).value) < 0 ? this : other;
        }
        return Collations.compare(collator, this.value, other.getStringValue()) < 0 ? this : other;
    }

    @Override
    public boolean startsWith(Collator collator, AtomicValue other) throws XPathException {
        return Collations.startsWith(collator, this.value, other.getStringValue());
    }

    @Override
    public boolean endsWith(Collator collator, AtomicValue other) throws XPathException {
        return Collations.endsWith(collator, this.value, other.getStringValue());
    }

    @Override
    public boolean contains(Collator collator, AtomicValue other) throws XPathException {
        return Collations.indexOf(collator, this.value, other.getStringValue()) != -1;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return !this.value.isEmpty();
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(StringValue.class)) {
            return 0;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 1;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(UntypedAtomicValue.class)) {
            return (T)this;
        }
        if (target == Object.class || target == String.class || target == CharSequence.class) {
            return (T)this.value;
        }
        if (target == Double.TYPE || target == Double.class) {
            DoubleValue v = (DoubleValue)this.convertTo(34);
            return (T)Double.valueOf(v.getValue());
        }
        if (target == Float.TYPE || target == Float.class) {
            FloatValue v = (FloatValue)this.convertTo(33);
            return (T)Float.valueOf(v.value);
        }
        if (target == Long.TYPE || target == Long.class) {
            IntegerValue v = (IntegerValue)this.convertTo(37);
            return (T)Long.valueOf(v.getInt());
        }
        if (target == Integer.TYPE || target == Integer.class) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return (T)Integer.valueOf(v.getInt());
        }
        if (target == Short.TYPE || target == Short.class) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return (T)Short.valueOf((short)v.getInt());
        }
        if (target == Byte.TYPE || target == Byte.class) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return (T)Byte.valueOf((byte)v.getInt());
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return (T)Boolean.valueOf(this.effectiveBooleanValue());
        }
        if (target == Character.TYPE || target == Character.class) {
            if (this.value.length() > 1 || this.value.isEmpty()) {
                throw new XPathException("cannot convert string with length = 0 or length > 1 to Java character");
            }
            return (T)Character.valueOf(this.value.charAt(0));
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof UntypedAtomicValue) {
            return this.value.equals(((UntypedAtomicValue)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

