/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xslt;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.BrokerPool;

public class TransformerFactoryAllocator {
    private static final Logger LOG = LogManager.getLogger(TransformerFactoryAllocator.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "transformer";
    public static final String TRANSFORMER_CLASS_ATTRIBUTE = "class";
    public static final String PROPERTY_TRANSFORMER_CLASS = "transformer.class";
    public static final String CONFIGURATION_TRANSFORMER_ATTRIBUTE_ELEMENT_NAME = "attribute";
    public static final String PROPERTY_TRANSFORMER_ATTRIBUTES = "transformer.attributes";
    public static final String TRANSFORMER_CACHING_ATTRIBUTE = "caching";
    public static final String PROPERTY_CACHING_ATTRIBUTE = "transformer.caching";
    public static final String PROPERTY_BROKER_POOL = "transformer.brokerPool";

    private TransformerFactoryAllocator() {
    }

    public static SAXTransformerFactory getTransformerFactory(BrokerPool pool) {
        SAXTransformerFactory factory;
        String transformerFactoryClassName = (String)pool.getConfiguration().getProperty(PROPERTY_TRANSFORMER_CLASS);
        if (transformerFactoryClassName == null) {
            factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        } else {
            try {
                factory = (SAXTransformerFactory)Class.forName(transformerFactoryClassName).newInstance();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set transformer factory: " + transformerFactoryClassName);
                }
                Hashtable attributes = (Hashtable)pool.getConfiguration().getProperty(PROPERTY_TRANSFORMER_ATTRIBUTES);
                Enumeration attrNames = attributes.keys();
                while (attrNames.hasMoreElements()) {
                    String name = (String)attrNames.nextElement();
                    Object value = attributes.get(name);
                    try {
                        factory.setAttribute(name, value);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Set transformer attribute: , name: " + name + ", value: " + value);
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.warn("Unable to set attribute for TransformerFactory: '" + transformerFactoryClassName + "', name: " + name + ", value: " + value + ", exception: " + iae.getMessage());
                    }
                }
                try {
                    factory.setAttribute(PROPERTY_BROKER_POOL, pool);
                }
                catch (Exception exception) {}
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error found loading the requested TrAX Transformer Factory '" + transformerFactoryClassName + "'. Using default TrAX Transformer Factory instead: " + e);
                }
                factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
        }
        return factory;
    }
}

