/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.DocumentTriggers;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.w3c.dom.NodeList;

public abstract class Modification {
    protected static final Logger LOG = LogManager.getLogger(Modification.class);
    protected String selectStmt = null;
    protected NodeList content = null;
    protected DBBroker broker;
    protected DocumentSet docs;
    protected Map<String, String> namespaces;
    protected Map<String, Object> variables;
    protected DocumentSet lockedDocuments = null;
    protected MutableDocumentSet modifiedDocuments = new DefaultDocumentSet();
    protected Int2ObjectHashMap<DocumentTrigger> triggers;

    private Modification() {
    }

    public Modification(DBBroker broker, DocumentSet docs, String selectStmt, Map<String, String> namespaces, Map<String, Object> variables) {
        this.selectStmt = selectStmt;
        this.broker = broker;
        this.docs = docs;
        this.namespaces = new HashMap<String, String>(namespaces);
        this.variables = new TreeMap<String, Object>(variables);
        this.triggers = new Int2ObjectHashMap(97);
    }

    public abstract long process(Txn var1) throws PermissionDeniedException, LockException, EXistException, XPathException, TriggerException;

    public abstract String getName();

    public void setContent(NodeList nodes) {
        this.content = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeList select(DocumentSet docs) throws PermissionDeniedException, EXistException, XPathException {
        StringSource source;
        XQuery xquery = this.broker.getBrokerPool().getXQueryService();
        XQueryPool pool = this.broker.getBrokerPool().getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(this.broker, source = new StringSource(this.selectStmt));
        XQueryContext context = compiled == null ? new XQueryContext(this.broker.getBrokerPool()) : compiled.getContext();
        context.setStaticallyKnownDocuments(docs);
        this.declareNamespaces(context);
        this.declareVariables(context);
        if (compiled == null) {
            try {
                compiled = xquery.compile(this.broker, context, source);
            }
            catch (IOException e) {
                throw new EXistException("An exception occurred while compiling the query: " + e.getMessage());
            }
        }
        Sequence resultSeq = null;
        try {
            resultSeq = xquery.execute(this.broker, compiled, null);
        }
        finally {
            context.runCleanupTasks();
            pool.returnCompiledXQuery(source, compiled);
        }
        if (!resultSeq.isEmpty() && !Type.subTypeOf(resultSeq.getItemType(), -1)) {
            throw new EXistException("select expression should evaluate to a node-set; got " + Type.getTypeName(resultSeq.getItemType()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("found " + resultSeq.getItemCount() + " for select: " + this.selectStmt);
        }
        return resultSeq.toNodeSet();
    }

    protected void declareVariables(XQueryContext context) throws XPathException {
        for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
            context.declareVariable(entry.getKey(), entry.getValue());
        }
    }

    protected void declareNamespaces(XQueryContext context) throws XPathException {
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            context.declareNamespace(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final StoredNode[] selectAndLock(Txn transaction) throws LockException, PermissionDeniedException, EXistException, XPathException, TriggerException {
        Lock globalLock = this.broker.getBrokerPool().getGlobalUpdateLock();
        globalLock.lock();
        try {
            NodeList nl = this.select(this.docs);
            this.lockedDocuments = ((NodeSet)nl).getDocumentSet();
            this.lockedDocuments.lock(this.broker, true);
            StoredNode[] ql = new StoredNode[nl.getLength()];
            for (int i = 0; i < ql.length; ++i) {
                ql[i] = (StoredNode)nl.item(i);
                DocumentImpl doc = ql[i].getOwnerDocument();
                this.prepareTrigger(transaction, doc);
            }
            StoredNode[] storedNodeArray = ql;
            return storedNodeArray;
        }
        finally {
            globalLock.unlock();
        }
    }

    protected final void unlockDocuments(Txn transaction) throws TriggerException {
        if (this.lockedDocuments == null) {
            return;
        }
        try {
            Iterator<DocumentImpl> iterator = this.modifiedDocuments.getDocumentIterator();
            while (iterator.hasNext()) {
                this.finishTrigger(transaction, iterator.next());
            }
        }
        finally {
            this.triggers.clear();
            this.modifiedDocuments.clear();
            this.lockedDocuments.unlock();
            this.lockedDocuments = null;
        }
    }

    protected void checkFragmentation(Txn transaction, DocumentSet docs) throws EXistException {
        int fragmentationLimit = -1;
        Object property = this.broker.getBrokerPool().getConfiguration().getProperty("xupdate.fragmentation");
        if (property != null) {
            fragmentationLimit = (Integer)property;
        }
        Iterator<DocumentImpl> i = docs.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl next = i.next();
            if (next.getMetadata().getSplitCount() > fragmentationLimit) {
                this.broker.defragXMLResource(transaction, next);
            }
            this.broker.checkXMLResourceConsistency(next);
        }
    }

    private void prepareTrigger(Txn transaction, DocumentImpl doc) throws TriggerException {
        Collection col = doc.getCollection();
        DocumentTriggers trigger = new DocumentTriggers(this.broker, col);
        trigger.beforeUpdateDocument(this.broker, transaction, doc);
        this.triggers.put(doc.getDocId(), trigger);
    }

    private void finishTrigger(Txn transaction, DocumentImpl doc) throws TriggerException {
        DocumentTrigger trigger = this.triggers.get(doc.getDocId());
        if (trigger != null) {
            trigger.afterUpdateDocument(this.broker, transaction, doc);
        }
    }

    public String toString() {
        return "<xu:" + this.getName() + " select=\"" + this.selectStmt + "\"></xu:" + this.getName() + ">";
    }
}

