/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.NodeListImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSetHelper;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.FastStringBuffer;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xupdate.Append;
import org.exist.xupdate.Conditional;
import org.exist.xupdate.Insert;
import org.exist.xupdate.Modification;
import org.exist.xupdate.Remove;
import org.exist.xupdate.Rename;
import org.exist.xupdate.Replace;
import org.exist.xupdate.Update;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XUpdateProcessor
implements ContentHandler,
LexicalHandler {
    public static final String MODIFICATIONS = "modifications";
    public static final String INSERT_AFTER = "insert-after";
    public static final String INSERT_BEFORE = "insert-before";
    public static final String REPLACE = "replace";
    public static final String RENAME = "rename";
    public static final String REMOVE = "remove";
    public static final String APPEND = "append";
    public static final String UPDATE = "update";
    public static final String COMMENT = "comment";
    public static final String PROCESSING_INSTRUCTION = "processing-instruction";
    public static final String TEXT = "text";
    public static final String ATTRIBUTE = "attribute";
    public static final String ELEMENT = "element";
    public static final String VALUE_OF = "value-of";
    public static final String VARIABLE = "variable";
    public static final String IF = "if";
    public static final String XUPDATE_NS = "http://www.xmldb.org/xupdate";
    private static final Logger LOG = LogManager.getLogger(XUpdateProcessor.class);
    private NodeListImpl contents = null;
    private boolean inModification = false;
    private boolean inAttribute = false;
    private boolean preserveWhitespace = false;
    private boolean preserveWhitespaceTemp = false;
    private Stack<String> spaceStack = null;
    private Modification modification = null;
    private DocumentBuilder builder;
    private Document doc;
    private Stack<Element> stack = new Stack();
    private Node currentNode = null;
    private DBBroker broker;
    private DocumentSet documentSet;
    private List<Modification> modifications = new ArrayList<Modification>();
    private FastStringBuffer charBuf = new FastStringBuffer(64);
    private Map<String, Object> variables = new TreeMap<String, Object>();
    private Map<String, String> namespaces = new HashMap<String, String>(10);
    private Stack<Conditional> conditionals = new Stack();

    public XUpdateProcessor(DBBroker broker, DocumentSet docs) throws ParserConfigurationException {
        Configuration config;
        Boolean temp;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        this.builder = factory.newDocumentBuilder();
        this.broker = broker;
        this.documentSet = docs;
        if (broker != null && (temp = (Boolean)(config = broker.getConfiguration()).getProperty("indexer.preserve-whitespace-mixed-content")) != null) {
            this.preserveWhitespaceTemp = temp;
        }
    }

    public void setBroker(DBBroker broker) {
        this.broker = broker;
    }

    public void setDocumentSet(DocumentSet docs) {
        this.documentSet = docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Modification[] parse(InputSource is) throws ParserConfigurationException, IOException, SAXException {
        XMLReader reader = this.broker.getBrokerPool().getParserPool().borrowXMLReader();
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            reader.setContentHandler(this);
            reader.parse(is);
            Modification[] mods = new Modification[this.modifications.size()];
            Modification[] modificationArray = this.modifications.toArray(mods);
            return modificationArray;
        }
        finally {
            this.broker.getBrokerPool().getParserPool().returnXMLReader(reader);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.preserveWhitespace = this.preserveWhitespaceTemp;
        this.spaceStack = new Stack();
        this.spaceStack.push("default");
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.inModification && this.charBuf.length() > 0) {
            String normalized;
            String string = normalized = this.preserveWhitespace ? this.charBuf.toString() : this.charBuf.getNormalizedString(3);
            if (normalized.length() > 0) {
                Object text = this.doc.createTextNode(this.charBuf.toString());
                if (this.stack.isEmpty()) {
                    this.contents.add((Node)text);
                } else {
                    Element last = this.stack.peek();
                    last.appendChild((Node)text);
                }
            }
            this.charBuf.setLength(0);
        }
        if (namespaceURI.equals(XUPDATE_NS)) {
            int p;
            String name;
            String select = null;
            switch (localName) {
                case "modifications": {
                    this.startModifications(atts);
                    return;
                }
                case "variable": {
                    this.startVariableDecl(atts);
                    return;
                }
                case "if": {
                    if (this.inModification) {
                        throw new SAXException("xupdate:if is not allowed inside a modification");
                    }
                    select = atts.getValue("test");
                    Conditional cond = new Conditional(this.broker, this.documentSet, select, this.namespaces, this.variables);
                    this.conditionals.push(cond);
                    return;
                }
                case "value-of": {
                    if (this.inModification) break;
                    throw new SAXException("xupdate:value-of is not allowed outside a modification");
                }
                case "append": 
                case "insert-before": 
                case "insert-after": 
                case "remove": 
                case "rename": 
                case "update": 
                case "replace": {
                    if (this.inModification) {
                        throw new SAXException("nested modifications are not allowed");
                    }
                    select = atts.getValue("select");
                    if (select == null) {
                        throw new SAXException(localName + " requires a select attribute");
                    }
                    this.doc = this.builder.newDocument();
                    this.contents = new NodeListImpl();
                    this.inModification = true;
                    break;
                }
                case "element": 
                case "attribute": 
                case "text": 
                case "processing-instruction": 
                case "comment": {
                    if (!this.inModification) {
                        throw new SAXException("creation elements are only allowed inside a modification");
                    }
                    this.charBuf.setLength(0);
                    break;
                }
                default: {
                    throw new SAXException("Unknown XUpdate element: " + qName);
                }
            }
            if (APPEND.equals(localName)) {
                String child = atts.getValue("child");
                this.modification = new Append(this.broker, this.documentSet, select, child, this.namespaces, this.variables);
            } else if (UPDATE.equals(localName)) {
                this.modification = new Update(this.broker, this.documentSet, select, this.namespaces, this.variables);
            } else if (INSERT_BEFORE.equals(localName)) {
                this.modification = new Insert(this.broker, this.documentSet, select, 0, this.namespaces, this.variables);
            } else if (INSERT_AFTER.equals(localName)) {
                this.modification = new Insert(this.broker, this.documentSet, select, 1, this.namespaces, this.variables);
            } else if (REMOVE.equals(localName)) {
                this.modification = new Remove(this.broker, this.documentSet, select, this.namespaces, this.variables);
            } else if (RENAME.equals(localName)) {
                this.modification = new Rename(this.broker, this.documentSet, select, this.namespaces, this.variables);
            } else if (REPLACE.equals(localName)) {
                this.modification = new Replace(this.broker, this.documentSet, select, this.namespaces, this.variables);
            } else if (ELEMENT.equals(localName)) {
                Element elem;
                name = atts.getValue("name");
                if (name == null) {
                    throw new SAXException("element requires a name attribute");
                }
                p = name.indexOf(58);
                String namespace = null;
                String prefix = "";
                if (p != -1) {
                    prefix = name.substring(0, p);
                    if (name.length() == p + 1) {
                        throw new SAXException("illegal prefix in qname: " + name);
                    }
                    name = name.substring(p + 1);
                    namespace = atts.getValue("namespace");
                    if (namespace == null) {
                        namespace = this.namespaces.get(prefix);
                    }
                    if (namespace == null) {
                        throw new SAXException("no namespace defined for prefix " + prefix);
                    }
                }
                if (namespace != null && namespace.length() > 0) {
                    elem = this.doc.createElementNS(namespace, name);
                    elem.setPrefix(prefix);
                } else {
                    elem = this.doc.createElement(name);
                }
                if (this.stack.isEmpty()) {
                    this.contents.add(elem);
                } else {
                    Element last = this.stack.peek();
                    last.appendChild(elem);
                }
                this.setWhitespaceHandling(this.stack.push(elem));
            } else if (ATTRIBUTE.equals(localName)) {
                Attr attrib;
                name = atts.getValue("name");
                if (name == null) {
                    throw new SAXException("attribute requires a name attribute");
                }
                p = name.indexOf(58);
                String namespace = null;
                if (p != -1) {
                    String prefix = name.substring(0, p);
                    if (name.length() == p + 1) {
                        throw new SAXException("illegal prefix in qname: " + name);
                    }
                    namespace = atts.getValue("namespace");
                    if (namespace == null) {
                        namespace = this.namespaces.get(prefix);
                    }
                    if (namespace == null) {
                        throw new SAXException("no namespace defined for prefix " + prefix);
                    }
                }
                Attr attr = attrib = namespace != null && namespace.length() > 0 ? this.doc.createAttributeNS(namespace, name) : this.doc.createAttribute(name);
                if (this.stack.isEmpty()) {
                    for (int i = 0; i < this.contents.getLength(); ++i) {
                        String nname;
                        Node n = this.contents.item(i);
                        String ns = n.getNamespaceURI();
                        String string = nname = ns == null ? n.getNodeName() : n.getLocalName();
                        if (ns == null) {
                            ns = "";
                        }
                        if (n.getNodeType() != 2 || !nname.equals(name) || !ns.equals(namespace)) continue;
                        throw new SAXException("The attribute " + attrib.getNodeName() + " cannot be specified twice");
                    }
                    this.contents.add(attrib);
                } else {
                    Element last = this.stack.peek();
                    if (namespace != null && last.hasAttributeNS(namespace, name) || namespace == null && last.hasAttribute(name)) {
                        throw new SAXException("The attribute " + attrib.getNodeName() + " cannot be specified twice on the same element");
                    }
                    if (namespace != null) {
                        last.setAttributeNodeNS(attrib);
                    } else {
                        last.setAttributeNode(attrib);
                    }
                }
                this.inAttribute = true;
                this.currentNode = attrib;
            } else if (VALUE_OF.equals(localName)) {
                select = atts.getValue("select");
                if (select == null) {
                    throw new SAXException("value-of requires a select attribute");
                }
                Sequence seq = this.processQuery(select);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + seq.getItemCount() + " items for value-of");
                }
                try {
                    SequenceIterator i = seq.iterate();
                    while (i.hasNext()) {
                        Item item = i.nextItem();
                        if (Type.subTypeOf(item.getType(), -1)) {
                            Node node = NodeSetHelper.copyNode(this.doc, ((NodeValue)item).getNode());
                            if (this.stack.isEmpty()) {
                                this.contents.add(node);
                                continue;
                            }
                            Element last = this.stack.peek();
                            last.appendChild(node);
                            continue;
                        }
                        String value = item.getStringValue();
                        this.characters(value.toCharArray(), 0, value.length());
                    }
                }
                catch (XPathException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            }
        } else if (this.inModification) {
            Element elem = namespaceURI != null && namespaceURI.length() > 0 ? this.doc.createElementNS(namespaceURI, qName) : this.doc.createElement(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getQName(i);
                String nsURI = atts.getURI(i);
                if (name.startsWith("xmlns")) continue;
                Attr a = nsURI != null ? this.doc.createAttributeNS(nsURI, name) : this.doc.createAttribute(name);
                a.setValue(atts.getValue(i));
                if (nsURI != null) {
                    elem.setAttributeNodeNS(a);
                    continue;
                }
                elem.setAttributeNode(a);
            }
            if (this.stack.isEmpty()) {
                this.contents.add(elem);
            } else {
                Element last = this.stack.peek();
                last.appendChild(elem);
            }
            this.setWhitespaceHandling(this.stack.push(elem));
        }
    }

    private void startVariableDecl(Attributes atts) throws SAXException {
        String select = atts.getValue("select");
        if (select == null) {
            throw new SAXException("variable declaration requires a select attribute");
        }
        String name = atts.getValue("name");
        if (name == null) {
            throw new SAXException("variable declarations requires a name attribute");
        }
        this.createVariable(name, select);
    }

    private void startModifications(Attributes atts) throws SAXException {
        String version = atts.getValue("version");
        if (version == null) {
            throw new SAXException("version attribute is required for element modifications");
        }
        if (!"1.0".equals(version)) {
            throw new SAXException("Version " + version + " of XUpdate not supported.");
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.inModification && this.charBuf.length() > 0) {
            String normalized;
            String string = normalized = this.preserveWhitespace ? this.charBuf.toString() : this.charBuf.getNormalizedString(3);
            if (normalized.length() > 0) {
                Text text = this.doc.createTextNode(this.charBuf.toString());
                if (this.stack.isEmpty()) {
                    this.contents.add(text);
                } else {
                    Element last = this.stack.peek();
                    last.appendChild(text);
                }
            }
            this.charBuf.setLength(0);
        }
        if (XUPDATE_NS.equals(namespaceURI)) {
            Conditional cond;
            if (IF.equals(localName)) {
                cond = this.conditionals.pop();
                this.modifications.add(cond);
            } else if (localName.equals(ELEMENT)) {
                this.resetWhitespaceHandling(this.stack.pop());
            } else if (localName.equals(ATTRIBUTE)) {
                this.inAttribute = false;
            } else if (localName.equals(APPEND) || localName.equals(UPDATE) || localName.equals(REMOVE) || localName.equals(RENAME) || localName.equals(REPLACE) || localName.equals(INSERT_BEFORE) || localName.equals(INSERT_AFTER)) {
                this.inModification = false;
                this.modification.setContent(this.contents);
                if (!this.conditionals.isEmpty()) {
                    cond = this.conditionals.peek();
                    cond.addModification(this.modification);
                } else {
                    this.modifications.add(this.modification);
                }
                this.modification = null;
            }
        } else if (this.inModification) {
            this.resetWhitespaceHandling(this.stack.pop());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inModification) {
            if (this.inAttribute) {
                Attr attr = (Attr)this.currentNode;
                String val = attr.getValue();
                val = val == null ? new String(ch, start, length) : val + new String(ch, start, length);
                attr.setValue(val);
            } else {
                this.charBuf.append(ch, start, length);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.preserveWhitespace && this.inModification) {
            if (this.inAttribute) {
                Attr attr = (Attr)this.currentNode;
                String val = attr.getValue();
                val = val == null ? new String(ch, start, length) : val + new String(ch, start, length);
                attr.setValue(val);
            } else {
                this.charBuf.append(ch, start, length);
            }
        }
    }

    private void setWhitespaceHandling(Element e) {
        String wsSetting = e.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space");
        if ("preserve".equals(wsSetting)) {
            this.spaceStack.push(wsSetting);
            this.preserveWhitespace = true;
        } else if ("default".equals(wsSetting)) {
            this.spaceStack.push(wsSetting);
            this.preserveWhitespace = this.preserveWhitespaceTemp;
        }
    }

    private void resetWhitespaceHandling(Element e) {
        String wsSetting = e.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space");
        if ("preserve".equals(wsSetting) || "default".equals(wsSetting)) {
            this.spaceStack.pop();
            this.preserveWhitespace = 0 == this.spaceStack.size() ? this.preserveWhitespaceTemp : "preserve".equals(this.spaceStack.peek());
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.inModification && this.charBuf.length() > 0) {
            String normalized = this.charBuf.getNormalizedString(3);
            if (normalized.length() > 0) {
                Text text = this.doc.createTextNode(normalized);
                if (this.stack.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("appending text to fragment: " + text.getData());
                    }
                    this.contents.add(text);
                } else {
                    Element last = this.stack.peek();
                    last.appendChild(text);
                }
            }
            this.charBuf.setLength(0);
        }
        if (this.inModification) {
            ProcessingInstruction pi = this.doc.createProcessingInstruction(target, data);
            if (this.stack.isEmpty()) {
                this.contents.add(pi);
            } else {
                Element last = this.stack.peek();
                last.appendChild(pi);
            }
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private void createVariable(String name, String select) throws SAXException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating variable " + name + " as " + select);
        }
        Sequence result = this.processQuery(select);
        if (LOG.isDebugEnabled()) {
            LOG.debug("found " + result.getItemCount() + " for variable " + name);
        }
        this.variables.put(name, result);
    }

    private Sequence processQuery(String select) throws SAXException {
        XQueryContext context = null;
        try {
            Sequence seq;
            context = new XQueryContext(this.broker.getBrokerPool());
            context.setStaticallyKnownDocuments(this.documentSet);
            for (Map.Entry<String, String> namespaceEntry : this.namespaces.entrySet()) {
                context.declareNamespace(namespaceEntry.getKey(), namespaceEntry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                context.declareVariable(entry.getKey(), entry.getValue());
            }
            XQueryLexer lexer = new XQueryLexer(context, new StringReader(select));
            XQueryParser parser = new XQueryParser(lexer);
            XQueryTreeParser treeParser = new XQueryTreeParser(context);
            parser.xpath();
            if (parser.foundErrors()) {
                throw new SAXException(parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            if (LOG.isDebugEnabled()) {
                LOG.debug("generated AST: " + ast.toStringTree());
            }
            PathExpr expr = new PathExpr(context);
            treeParser.xpath(ast, expr);
            if (treeParser.foundErrors()) {
                throw new SAXException(treeParser.getErrorMessage());
            }
            expr.analyze(new AnalyzeContextInfo());
            Sequence sequence = seq = expr.eval(null, null);
            return sequence;
        }
        catch (RecognitionException e) {
            LOG.warn("error while creating variable", (Throwable)e);
            throw new SAXException((Exception)((Object)e));
        }
        catch (TokenStreamException e) {
            LOG.warn("error while creating variable", (Throwable)e);
            throw new SAXException((Exception)((Object)e));
        }
        catch (XPathException e) {
            throw new SAXException(e);
        }
        finally {
            if (context != null) {
                context.reset(false);
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.inModification && this.charBuf.length() > 0) {
            String normalized = this.charBuf.getNormalizedString(3);
            if (normalized.length() > 0) {
                Text text = this.doc.createTextNode(normalized);
                if (this.stack.isEmpty()) {
                    this.contents.add(text);
                } else {
                    Element last = this.stack.peek();
                    last.appendChild(text);
                }
            }
            this.charBuf.setLength(0);
        }
        if (this.inModification) {
            Comment comment = this.doc.createComment(new String(ch, start, length));
            if (this.stack.isEmpty()) {
                this.contents.add(comment);
            } else {
                Element last = this.stack.peek();
                last.appendChild(comment);
            }
        }
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    public void reset() {
        this.preserveWhitespace = false;
        this.spaceStack = null;
        this.inModification = false;
        this.inAttribute = false;
        this.modification = null;
        this.doc = null;
        this.contents = null;
        this.stack.clear();
        this.currentNode = null;
        this.broker = null;
        this.documentSet = null;
        this.modifications.clear();
        this.charBuf = new FastStringBuffer(64);
        this.variables.clear();
        this.namespaces.clear();
        this.conditionals.clear();
    }
}

