/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.Account;
import org.exist.security.internal.aider.UserAider;
import org.xmldb.api.base.XMLDBException;

public class AddUserTask
extends UserTask {
    private String name;
    private String primaryGroup;
    private String secret;

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (this.name == null) {
            throw new BuildException("Must specify at leat a user name");
        }
        try {
            UserAider usr = new UserAider(this.name);
            if (this.secret != null) {
                usr.setPassword(this.secret);
            }
            if (this.primaryGroup != null) {
                usr.addGroup(this.primaryGroup);
            }
            this.log("Adding user " + this.name, 2);
            this.service.addAccount((Account)usr);
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryGroup(String primaryGroup) {
        this.primaryGroup = primaryGroup;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }
}

