/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.Account;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class LockResourceTask
extends UserTask {
    private String name = null;
    private String resource = null;

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (this.resource == null || this.name == null) {
            throw new BuildException("Must specify user and resource name");
        }
        try {
            Resource res = this.base.getResource(this.resource);
            if (res == null) {
                String msg = "Resource " + this.resource + " not found";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            } else {
                Account usr = this.service.getAccount(this.name);
                if (usr == null) {
                    String msg = "User " + this.name + " not found";
                    if (this.failonerror) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                } else {
                    this.service.lockResource(res, usr);
                }
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setName(String user) {
        this.name = user;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

