/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.Group;
import org.xmldb.api.base.XMLDBException;

public class RemoveGroupTask
extends UserTask {
    private String name = null;

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (this.name == null) {
            throw new BuildException("You have to specify a name");
        }
        this.log("Removing group " + this.name, 2);
        try {
            Group group = this.service.getGroup(this.name);
            if (group != null) {
                this.service.removeGroup(group);
            } else {
                this.log("Group " + this.name + " does not exist.", 2);
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setName(String name) {
        this.name = name;
    }
}

