/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.Account;
import org.xmldb.api.base.XMLDBException;

public class RemoveUserTask
extends UserTask {
    private String name = null;

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (this.name == null) {
            throw new BuildException("You have to specify a name");
        }
        try {
            Account u = this.service.getAccount(this.name);
            if (u != null) {
                this.service.removeAccount(u);
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setName(String name) {
        this.name = name;
    }
}

