/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.DirSet;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.backup.Restore;
import org.exist.backup.restore.listener.ConsoleRestoreListener;
import org.exist.backup.restore.listener.RestoreListener;

public class RestoreTask
extends AbstractXMLDBTask {
    private Path zipFile = null;
    private Path dir = null;
    private DirSet dirSet = null;
    private String restorePassword = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("You have to specify an XMLDB collection URI");
        }
        if (this.dir == null && this.dirSet == null && this.zipFile == null) {
            throw new BuildException("Missing required argument: either dir, dirset or file required");
        }
        if (this.dir != null && !Files.isReadable(this.dir)) {
            String msg = "Cannot read restore file: " + this.dir.toAbsolutePath().toString();
            if (this.failonerror) {
                throw new BuildException(msg);
            }
            this.log(msg, 0);
        } else {
            this.registerDatabase();
            try {
                if (this.dir != null) {
                    this.log("Restoring from " + this.dir.toAbsolutePath().toString(), 2);
                    Path file = this.dir.resolve("__contents__.xml");
                    if (!Files.exists(file, new LinkOption[0])) {
                        String msg = "Could not find file " + file.toAbsolutePath().toString();
                        if (this.failonerror) {
                            throw new BuildException(msg);
                        }
                        this.log(msg, 0);
                    } else {
                        Restore restore = new Restore();
                        ConsoleRestoreListener listener = new ConsoleRestoreListener();
                        restore.restore((RestoreListener)listener, this.user, this.password, this.restorePassword, file, this.uri);
                    }
                } else if (this.dirSet != null) {
                    DirectoryScanner scanner = this.dirSet.getDirectoryScanner(this.getProject());
                    scanner.scan();
                    String[] includedFiles = scanner.getIncludedFiles();
                    this.log("Found " + includedFiles.length + " files.\n");
                    for (String included : includedFiles) {
                        this.dir = scanner.getBasedir().toPath().resolve(included);
                        Path contentsFile = this.dir.resolve("__contents__.xml");
                        if (!Files.exists(contentsFile, new LinkOption[0])) {
                            String msg = "Did not found file " + contentsFile.toAbsolutePath().toString();
                            if (this.failonerror) {
                                throw new BuildException(msg);
                            }
                            this.log(msg, 0);
                            continue;
                        }
                        this.log("Restoring from " + contentsFile.toAbsolutePath().toString() + " ...\n");
                        Restore restore = new Restore();
                        ConsoleRestoreListener listener = new ConsoleRestoreListener();
                        restore.restore((RestoreListener)listener, this.user, this.password, this.restorePassword, contentsFile, this.uri);
                    }
                } else if (this.zipFile != null) {
                    this.log("Restoring from " + this.zipFile.toAbsolutePath().toString(), 2);
                    if (!Files.exists(this.zipFile, new LinkOption[0])) {
                        String msg = "File not found: " + this.zipFile.toAbsolutePath().toString();
                        if (this.failonerror) {
                            throw new BuildException(msg);
                        }
                        this.log(msg, 0);
                    } else {
                        Restore restore = new Restore();
                        ConsoleRestoreListener listener = new ConsoleRestoreListener();
                        restore.restore((RestoreListener)listener, this.user, this.password, this.restorePassword, this.zipFile, this.uri);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "Exception during restore: " + e.getMessage();
                if (this.failonerror) {
                    throw new BuildException(msg, (Throwable)e);
                }
                this.log(msg, e, 0);
            }
        }
    }

    public DirSet createDirSet() {
        this.dirSet = new DirSet();
        return this.dirSet;
    }

    public void setDir(File dir) {
        this.dir = dir.toPath();
    }

    public void setFile(File file) {
        this.zipFile = file.toPath();
    }

    public void setRestorePassword(String pass) {
        this.restorePassword = pass;
    }
}

