/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.Account;
import org.exist.security.User;
import org.xmldb.api.base.XMLDBException;

public class UserPasswordTask
extends UserTask {
    private String name;
    private String secret;

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (this.name == null) {
            throw new BuildException("Must specify at least a user name");
        }
        try {
            this.log("Looking up user " + this.name, 2);
            Account usr = this.service.getAccount(this.name);
            if (usr != null) {
                this.log("Setting password for user " + this.name, 2);
                if (this.secret != null) {
                    usr.setPassword(this.secret);
                    this.service.updateUser((User)usr);
                }
            } else {
                String msg = "user " + this.name + " not found";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }
}

