/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBCreateTask
extends AbstractXMLDBTask {
    private String collection = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        this.registerDatabase();
        try {
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                String msg = "Collection " + this.uri + " could not be found.";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            } else {
                Collection root = null;
                if (this.collection != null) {
                    this.log("Creating collection " + this.collection + " in base collection " + this.uri, 4);
                    root = this.mkcol(base, this.uri, this.collection);
                } else {
                    root = base;
                }
                if (this.permissions != null) {
                    this.setPermissions(root);
                }
                this.log("Created collection " + root.getName(), 2);
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
        catch (URISyntaxException e) {
            String msg = "URISyntaxException: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    private Collection mkcol(Collection root, String base, String relPath) throws XMLDBException, URISyntaxException {
        XmldbURI[] segments;
        Collection current = root;
        XmldbURI baseUri = XmldbURI.xmldbUriFor((String)base);
        XmldbURI collPath = XmldbURI.xmldbUriFor((String)relPath);
        this.log("BASEURI=" + baseUri, 4);
        this.log("RELPATH=" + relPath, 4);
        for (XmldbURI segment : segments = collPath.getPathSegments()) {
            baseUri = baseUri.append(segment);
            this.log("Get collection " + baseUri, 4);
            Collection c = DatabaseManager.getCollection((String)baseUri.toString(), (String)this.user, (String)this.password);
            if (c == null) {
                this.log("Create collection management service for collection " + current.getName(), 4);
                CollectionManagementService mgtService = (CollectionManagementService)current.getService("CollectionManagementService", "1.0");
                this.log("Create child collection " + segment);
                current = mgtService.createCollection(segment.toString());
                this.log("Created collection " + current.getName() + '.');
                continue;
            }
            current = c;
        }
        return current;
    }
}

