/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.xml.sax.ContentHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XMLDBXPathTask
extends AbstractXMLDBTask {
    private String resource = null;
    private String namespace = null;
    private String query = null;
    private String text = null;
    private boolean count = false;
    private File destDir = null;
    private String outputproperty;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        if (this.text != null) {
            PropertyHelper helper = PropertyHelper.getPropertyHelper((Project)this.getProject());
            this.query = helper.replaceProperties(null, this.text, null);
        }
        if (this.query == null) {
            throw new BuildException("you have to specify a query");
        }
        this.log("XPath is: " + this.query, 4);
        this.registerDatabase();
        try {
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                String msg = "Collection " + this.uri + " could not be found.";
                if (this.failonerror) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            } else {
                ResourceSet results;
                XPathQueryService service = (XPathQueryService)base.getService("XPathQueryService", "1.0");
                service.setProperty("indent", "yes");
                service.setProperty("encoding", "UTF-8");
                if (this.namespace != null) {
                    this.log("Using namespace: " + this.namespace, 4);
                    service.setNamespace("ns", this.namespace);
                }
                if (this.resource != null) {
                    this.log("Query resource: " + this.resource, 4);
                    results = service.queryResource(this.resource, this.query);
                } else {
                    this.log("Query collection", 4);
                    results = service.query(this.query);
                }
                this.log("Found " + results.getSize() + " results", 2);
                if (this.destDir != null && results != null) {
                    this.log("write results to directory " + this.destDir.getAbsolutePath(), 2);
                    ResourceIterator iter = results.getIterator();
                    this.log("Writing results to directory " + this.destDir.getAbsolutePath(), 4);
                    while (iter.hasMoreResources()) {
                        XMLResource res = (XMLResource)iter.nextResource();
                        this.log("Writing resource " + res.getId(), 4);
                        this.writeResource(res, this.destDir);
                    }
                } else if (this.outputproperty != null) {
                    if (this.count) {
                        this.getProject().setNewProperty(this.outputproperty, String.valueOf(results.getSize()));
                    } else {
                        ResourceIterator iter = results.getIterator();
                        StringBuilder result = new StringBuilder();
                        while (iter.hasMoreResources()) {
                            XMLResource res = (XMLResource)iter.nextResource();
                            result.append(res.getContent().toString());
                            result.append("\n");
                        }
                        this.getProject().setNewProperty(this.outputproperty, result.toString());
                    }
                }
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught while executing query: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
        catch (IOException e) {
            String msg = "XMLDB exception caught while writing destination file: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    private void writeResource(XMLResource resource, File dest) throws IOException, XMLDBException {
        if (dest != null) {
            OutputStreamWriter writer;
            Properties outputProperties = new Properties();
            outputProperties.setProperty("indent", "yes");
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            if (dest.isDirectory()) {
                String fname;
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!(fname = resource.getId()).endsWith(".xml")) {
                    fname = fname + ".xml";
                }
                File file = new File(dest, fname);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            } else {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dest), StandardCharsets.UTF_8);
            }
            serializer.setOutput((Writer)writer, outputProperties);
            resource.getContentAsSAX((ContentHandler)serializer);
            ((Writer)writer).close();
            SerializerPool.getInstance().returnObject((Object)serializer);
        } else {
            String msg = "Destination target does not exist.";
            if (this.failonerror) {
                throw new BuildException("Destination target does not exist.");
            }
            this.log("Destination target does not exist.", 0);
        }
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void addText(String text) {
        this.text = text;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOutputproperty(String outputproperty) {
        this.outputproperty = outputproperty;
    }

    public void setCount(boolean count) {
        this.count = count;
    }
}

