/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.filter;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DumpFilter
implements Filter {
    private static final Logger LOG = LogManager.getLogger(DumpFilter.class);
    private FilterConfig filterConfig = null;

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int i;
        if (!LOG.isInfoEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        LOG.info("== START ====================================");
        LOG.info("Request Received at " + new Timestamp(System.currentTimeMillis()));
        LOG.info("=============================================");
        LOG.info(" characterEncoding=" + request.getCharacterEncoding());
        LOG.info("     contentLength=" + request.getContentLength());
        LOG.info("       contentType=" + request.getContentType());
        LOG.info("            locale=" + request.getLocale());
        StringBuffer buffer = new StringBuffer();
        buffer.append("           locales=");
        Enumeration locales = request.getLocales();
        boolean first = true;
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(locale.toString());
        }
        LOG.info(buffer.toString());
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            buffer = new StringBuffer();
            buffer.append("         parameter=").append(name).append("=");
            String[] values = request.getParameterValues(name);
            for (i = 0; i < values.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(values[i]);
            }
            LOG.info(buffer.toString());
        }
        LOG.info("          protocol=" + request.getProtocol());
        LOG.info("        remoteAddr=" + request.getRemoteAddr());
        LOG.info("        remoteHost=" + request.getRemoteHost());
        LOG.info("            scheme=" + request.getScheme());
        LOG.info("        serverName=" + request.getServerName());
        LOG.info("        serverPort=" + request.getServerPort());
        LOG.info("          isSecure=" + request.isSecure());
        if (request instanceof HttpServletRequest) {
            LOG.info("---------------------------------------------");
            HttpServletRequest hrequest = (HttpServletRequest)request;
            LOG.info("       contextPath=" + hrequest.getContextPath());
            Cookie[] cookies = hrequest.getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            for (i = 0; i < cookies.length; ++i) {
                LOG.info("            cookie=" + cookies[i].getName() + "=" + cookies[i].getValue());
            }
            names = hrequest.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = hrequest.getHeader(name);
                LOG.info("            header=" + name + "=" + value);
            }
            LOG.info("            method=" + hrequest.getMethod());
            LOG.info("          pathInfo=" + hrequest.getPathInfo());
            LOG.info("       queryString=" + hrequest.getQueryString());
            LOG.info("        remoteUser=" + hrequest.getRemoteUser());
            LOG.info("requestedSessionId=" + hrequest.getRequestedSessionId());
            LOG.info("        requestURI=" + hrequest.getRequestURI());
            LOG.info("       servletPath=" + hrequest.getServletPath());
        }
        LOG.info("== END ======================================");
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "RequestDumperFilter()";
        }
        return "RequestDumperFilter(" + this.filterConfig + ")";
    }
}

