/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.filter;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.security.internal.SubjectImpl;

public class GuestFilter
implements Filter {
    private static final Logger LOG = LogManager.getLogger(GuestFilter.class);
    private String sslPort = null;
    private FilterConfig filterConfig = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("Starting GuestFilter");
        this.setFilterConfig(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            LOG.info("Servlet Request confirmed");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        LOG.info("HTTP Servlet Request confirmed");
        String username = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI().trim();
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            LOG.info("session: " + session.toString());
            Enumeration enumeration = session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object value = session.getAttribute(key);
                LOG.info("session attribute [" + key + "][" + value.toString() + "]");
                if (!key.equalsIgnoreCase("_eXist_xmldb_user")) continue;
                username = ((SubjectImpl)value).getUsername();
                LOG.info("username [" + username + "]");
            }
        } else {
            LOG.info("No valid session");
        }
        LOG.info("username [" + username + "]");
        LOG.info("requestURI [" + requestURI + "]");
        if (requestURI.indexOf("/webdav/") >= 0) {
            if (username != null && username.equalsIgnoreCase("guest")) {
                LOG.info("Permission denied to : " + requestURI);
                httpServletResponse.sendError(403);
            } else if (!httpServletRequest.isSecure()) {
                String serverName = httpServletRequest.getServerName();
                String path = httpServletRequest.getRequestURI();
                String newpath = "https://" + serverName + ":" + this.sslPort + path;
                LOG.info("Redirecting to SSL: " + newpath);
                httpServletResponse.sendRedirect(newpath);
            } else if (httpServletRequest.isSecure()) {
                LOG.info("Request is appropriate");
                filterChain.doFilter(servletRequest, servletResponse);
            }
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        LOG.info("Ending GuestFilter");
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        Enumeration initParams = filterConfig.getInitParameterNames();
        if (initParams != null) {
            this.sslPort = "443";
            while (initParams.hasMoreElements()) {
                String name = (String)initParams.nextElement();
                String value = filterConfig.getInitParameter(name);
                LOG.info("Parameter [" + name + "][" + value + "]");
                if (!name.equalsIgnoreCase("sslport")) continue;
                this.sslPort = value;
            }
        }
    }
}

