/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.filter;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PathFilter
implements Filter {
    private static final Logger LOG = LogManager.getLogger(PathFilter.class);
    private FilterConfig filterConfig;
    private static final String TEST_REST = "HTTP GET /rest/";
    private static final String TEST_GET_QUERY = "HTTP GET ?_query=";
    private static final String TEST_POST_XUPDATE = "HTTP POST XUpdate";
    private static final String TEST_POST_QUERY = "HTTP POST Query Document";
    private static final String TEST_DELETE = "HTTP DELETE";
    private static final String TEST_PUT = "HTTP PUT";
    private boolean allowFirst = false;
    private HashSet<String> allows = new HashSet();
    private HashSet<String> denys = new HashSet();
    private HashSet<String> filterNames = new HashSet();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.setFilterConfig(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.filterConfig == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (!(servletRequest instanceof HttpServletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        boolean conditionMet = false;
        String queryString = httpServletRequest.getQueryString();
        String requestURI = httpServletRequest.getRequestURI();
        LOG.info("requestURI = [" + requestURI + "]");
        LOG.info("queryString = [" + queryString + "]");
        LOG.info("method = [" + httpServletRequest.getMethod() + "]");
        if (queryString != null && queryString.indexOf("_query=") >= 0 && this.filterNames.contains(TEST_GET_QUERY)) {
            LOG.info("HTTP GET ?_query= met");
            conditionMet = true;
        } else if (requestURI != null && requestURI.indexOf("/rest/") >= 0 && this.filterNames.contains(TEST_REST)) {
            conditionMet = true;
            LOG.info("HTTP GET /rest/ met");
        } else if (httpServletRequest.getMethod().equalsIgnoreCase("PUT") && this.filterNames.contains(TEST_PUT)) {
            conditionMet = true;
            LOG.info("HTTP PUT met");
        } else if (httpServletRequest.getMethod().equalsIgnoreCase("DELETE") && this.filterNames.contains(TEST_DELETE)) {
            conditionMet = true;
            LOG.info("HTTP DELETE met");
        } else if (httpServletRequest.getMethod().equalsIgnoreCase("POST")) {
            // empty if block
        }
        if (!conditionMet) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (this.allowFirst) {
            if (this.allowMatch((ServletRequest)httpServletRequest)) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else if (this.denyMatch((ServletRequest)httpServletRequest)) {
            httpServletResponse.sendError(403);
        } else if (this.allowMatch((ServletRequest)httpServletRequest)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        httpServletResponse.sendError(403);
    }

    private String validName(ServletRequest servletRequest) {
        String address;
        String name = servletRequest.getRemoteHost();
        if (name.equalsIgnoreCase(address = servletRequest.getRemoteAddr())) {
            try {
                name = InetAddress.getByName(address).getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                name = null;
            }
        }
        return name;
    }

    private boolean denyMatch(ServletRequest servletRequest) {
        String name = this.validName(servletRequest);
        String address = servletRequest.getRemoteAddr();
        return this.denys.contains(address) || this.denys.contains(name);
    }

    private boolean allowMatch(ServletRequest servletRequest) {
        String name = this.validName(servletRequest);
        String address = servletRequest.getRemoteAddr();
        return this.allows.contains(address) || this.allows.contains(name);
    }

    public void destroy() {
        this.allows = null;
        this.denys = null;
        this.filterNames = null;
        this.filterConfig = null;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        Enumeration initParams = filterConfig.getInitParameterNames();
        if (initParams != null) {
            this.allows.clear();
            this.denys.clear();
            this.filterNames.clear();
            while (initParams.hasMoreElements()) {
                String name = (String)initParams.nextElement();
                String value = filterConfig.getInitParameter(name);
                LOG.info("Parameter [" + name + "][" + value + "]");
                if (name.startsWith("exclude")) {
                    this.denys.add(value);
                    continue;
                }
                if (name.startsWith("include")) {
                    this.allows.add(value);
                    continue;
                }
                if (name.startsWith("type")) {
                    this.filterNames.add(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("order")) continue;
                this.allowFirst = value.equalsIgnoreCase("allow,deny");
            }
        }
    }
}

