/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.exist.http.servlets.ResponseWrapper;

public class HttpResponseWrapper
implements ResponseWrapper {
    private HttpServletResponse response;
    private Map<String, Long> dateHeaders = new HashMap<String, Long>();

    public HttpResponseWrapper(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public void addCookie(String name, String value) {
        this.response.addCookie(new Cookie(name, this.encode(value)));
    }

    @Override
    public void addCookie(String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, this.encode(value));
        cookie.setMaxAge(maxAge);
        this.response.addCookie(cookie);
    }

    @Override
    public void addCookie(String name, String value, int maxAge, boolean secure) {
        Cookie cookie = new Cookie(name, this.encode(value));
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secure);
        this.response.addCookie(cookie);
    }

    @Override
    public void addCookie(String name, String value, int maxAge, boolean secure, String domain, String path) {
        Cookie cookie = new Cookie(name, this.encode(value));
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secure);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        this.response.addCookie(cookie);
    }

    @Override
    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    @Override
    public void addDateHeader(String arg0, long arg1) {
        this.response.addDateHeader(arg0, arg1);
    }

    @Override
    public void addHeader(String arg0, String arg1) {
        this.response.addHeader(arg0, this.encode(arg1));
    }

    @Override
    public void addIntHeader(String arg0, int arg1) {
        this.response.addIntHeader(arg0, arg1);
    }

    @Override
    public boolean containsHeader(String arg0) {
        return this.response.containsHeader(arg0);
    }

    @Override
    public String encodeURL(String arg0) {
        return this.response.encodeURL(arg0);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    @Override
    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    @Override
    public Locale getLocale() {
        return this.response.getLocale();
    }

    @Override
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void sendRedirect(String arg0) throws IOException {
        this.response.sendRedirect(arg0);
    }

    @Override
    public void setDateHeader(String name, long arg1) {
        this.dateHeaders.put(name, arg1);
        this.response.setDateHeader(name, arg1);
    }

    @Override
    public long getDateHeader(String name) {
        long ret = 0L;
        Long val = this.dateHeaders.get(name);
        if (val != null) {
            ret = val;
        }
        return ret;
    }

    @Override
    public void setHeader(String arg0, String arg1) {
        this.response.setHeader(arg0, this.encode(arg1));
    }

    @Override
    public void setIntHeader(String arg0, int arg1) {
        this.response.setIntHeader(arg0, arg1);
    }

    @Override
    public void setStatusCode(int arg0) {
        this.response.setStatus(arg0);
    }

    @Override
    public void setLocale(Locale arg0) {
        this.response.setLocale(arg0);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    private String encode(String value) {
        return new String(value.getBytes(), StandardCharsets.ISO_8859_1);
    }
}

