/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.http.servlets.HttpRequestWrapper;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.http.servlets.HttpSessionWrapper;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.xmldb.EXistCollection;
import org.exist.xmldb.EXistXQueryService;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

@Deprecated
public class RedirectorServlet
extends HttpServlet {
    private static final long serialVersionUID = 853971301553787943L;
    private static final Logger LOG = LogManager.getLogger(RedirectorServlet.class);
    public static final String DEFAULT_USER = "guest";
    public static final String DEFAULT_PASS = "guest";
    public static final XmldbURI DEFAULT_URI = XmldbURI.EMBEDDED_SERVER_URI.append(XmldbURI.ROOT_COLLECTION_URI);
    public static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    private String user = null;
    private String password = null;
    private XmldbURI collectionURI = null;
    private String query = null;

    public void init(ServletConfig config) throws ServletException {
        String confCollectionURI;
        super.init(config);
        this.query = config.getInitParameter("xquery");
        if (this.query == null) {
            throw new ServletException("RedirectorServlet requires a parameter 'xquery'.");
        }
        this.user = config.getInitParameter("user");
        if (this.user == null) {
            this.user = "guest";
        }
        this.password = config.getInitParameter("password");
        if (this.password == null) {
            this.password = "guest";
        }
        if ((confCollectionURI = config.getInitParameter("uri")) == null) {
            this.collectionURI = DEFAULT_URI;
        } else {
            try {
                this.collectionURI = XmldbURI.xmldbUriFor((String)confCollectionURI);
            }
            catch (URISyntaxException e) {
                throw new ServletException("Invalid XmldbURI for parameter 'uri': " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            Class<?> driver = Class.forName(DRIVER);
            Database database = (Database)driver.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            String errorMessage = "Failed to initialize database driver";
            LOG.error("Failed to initialize database driver", (Throwable)e);
            throw new ServletException("Failed to initialize database driver: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String qpath;
        Path p;
        if (request.getCharacterEncoding() == null) {
            try {
                request.setCharacterEncoding("UTF-8");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (!Files.isReadable(p = Paths.get(qpath = this.getServletContext().getRealPath(this.query), new String[0])) || !Files.isRegularFile(p, new LinkOption[0])) {
            throw new ServletException("Cannot read XQuery source from " + p.toAbsolutePath());
        }
        FileSource source = new FileSource(p, true);
        try {
            RequestDispatcher dispatcher;
            Collection collection = DatabaseManager.getCollection((String)this.collectionURI.toString(), (String)this.user, (String)this.password);
            EXistXQueryService service = (EXistXQueryService)collection.getService("XQueryService", "1.0");
            if (!((EXistCollection)collection).isRemoteCollection()) {
                service.declareVariable("request:request", (Object)new HttpRequestWrapper(request, "UTF-8", "UTF-8"));
                service.declareVariable("response:response", (Object)new HttpResponseWrapper(response));
                service.declareVariable("session:session", (Object)new HttpSessionWrapper(request.getSession(false)));
            }
            ResourceSet result = service.execute((Source)source);
            String redirectTo = null;
            String servletName = null;
            String path = null;
            RequestWrapper modifiedRequest = null;
            if (result.getSize() == 1L) {
                XMLResource resource = (XMLResource)result.getResource(0L);
                Node node = resource.getContentAsDOM();
                if (node.getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                if (node.getNodeType() != 1) {
                    response.sendError(400, "Redirect XQuery should return an XML element. Received: " + resource.getContent());
                    return;
                }
                Element elem = (Element)node;
                String ns = elem.getNamespaceURI();
                if (ns == null || !"http://exist.sourceforge.net/NS/exist".equals(ns) && "dispatch".equals(elem.getLocalName())) {
                    response.sendError(400, "Redirect XQuery should return an element <exist:dispatch>. Received: " + resource.getContent());
                    return;
                }
                if (elem.hasAttribute("path")) {
                    path = elem.getAttribute("path");
                } else if (elem.hasAttribute("servlet-name")) {
                    servletName = elem.getAttribute("servlet-name");
                } else if (elem.hasAttribute("redirect")) {
                    redirectTo = elem.getAttribute("redirect");
                } else {
                    response.sendError(400, "Element <exist:dispatch> should either provide an attribute 'path' or 'servlet-name'. Received: " + resource.getContent());
                    return;
                }
                if (elem.hasChildNodes()) {
                    for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                        String nsUri = node.getNamespaceURI();
                        if (node.getNodeType() != 1 || nsUri == null || !"http://exist.sourceforge.net/NS/exist".equals(nsUri) || !"add-parameter".equals((elem = (Element)node).getLocalName())) continue;
                        if (modifiedRequest == null) {
                            modifiedRequest = new RequestWrapper(request);
                        }
                        modifiedRequest.addParameter(elem.getAttribute("name"), elem.getAttribute("value"));
                    }
                }
            }
            if (redirectTo != null) {
                response.sendRedirect(redirectTo);
                return;
            }
            if (servletName != null && servletName.length() > 0) {
                dispatcher = this.getServletContext().getNamedDispatcher(servletName);
            } else {
                LOG.debug("Dispatching to " + path);
                dispatcher = this.getServletContext().getRequestDispatcher(path);
                if (dispatcher == null) {
                    dispatcher = request.getRequestDispatcher(path);
                }
            }
            if (dispatcher == null) {
                response.sendError(500, "Could not create a request dispatcher. Giving up.");
                return;
            }
            if (modifiedRequest != null) {
                request = modifiedRequest;
            }
            request.setAttribute("org.exist.forward.request-uri", (Object)request.getRequestURI());
            request.setAttribute("org.exist.forward.servlet-path", (Object)request.getServletPath());
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (XMLDBException e) {
            throw new ServletException("An error occurred while initializing RedirectorServlet: " + e.getMessage(), (Throwable)e);
        }
    }

    private static class RequestWrapper
    extends HttpServletRequestWrapper {
        Map<String, String[]> addedParams = new HashMap<String, String[]>();

        private RequestWrapper(HttpServletRequest request) {
            super(request);
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] value = request.getParameterValues(key);
                this.addedParams.put(key, value);
            }
        }

        public void addParameter(String name, String value) {
            this.addedParams.put(name, new String[]{value});
        }

        public String getParameter(String name) {
            String[] value = this.addedParams.get(name);
            if (value != null && value.length > 0) {
                return value[0];
            }
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return this.addedParams;
        }

        public Enumeration getParameterNames() {
            Vector<String> v = new Vector<String>();
            for (String key : this.addedParams.keySet()) {
                v.addElement(key);
            }
            return v.elements();
        }

        public String[] getParameterValues(String s) {
            String[] value = this.addedParams.get(s);
            return value;
        }
    }
}

