/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.debuggee.DebuggeeFactory;
import org.exist.dom.persistent.XMLUtil;
import org.exist.http.Descriptor;
import org.exist.http.servlets.AbstractExistHttpServlet;
import org.exist.http.servlets.HttpRequestWrapper;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.http.servlets.HttpServletRequestWrapper;
import org.exist.http.servlets.HttpSessionWrapper;
import org.exist.security.AuthenticationException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.security.internal.web.HttpAccount;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.util.MimeTable;
import org.exist.util.serializer.XQuerySerializer;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class XQueryServlet
extends AbstractExistHttpServlet {
    private static final long serialVersionUID = 5266794852401553015L;
    private static final Logger LOG = LogManager.getLogger(XQueryServlet.class);
    public static final String ATTR_XQUERY_USER = "xquery.user";
    public static final String ATTR_XQUERY_PASSWORD = "xquery.password";
    public static final String ATTR_XQUERY_SOURCE = "xquery.source";
    public static final String ATTR_XQUERY_URL = "xquery.url";
    public static final String ATTR_XQUERY_REPORT_ERRORS = "xquery.report-errors";
    public static final String ATTR_XQUERY_ATTRIBUTE = "xquery.attribute";
    public static final String ATTR_TIMEOUT = "xquery.timeout";
    public static final String ATTR_MAX_NODES = "xquery.max-nodes";
    public static final String ATTR_MODULE_LOAD_PATH = "xquery.module-load-path";
    public static final XmldbURI DEFAULT_URI = XmldbURI.EMBEDDED_SERVER_URI.append(XmldbURI.ROOT_COLLECTION_URI);
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    private XmldbURI collectionURI = null;
    private String encoding = null;
    private String contentType = null;
    private boolean hideErrorMessages = false;

    @Override
    public Logger getLog() {
        return LOG;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String confCollectionURI = config.getInitParameter("uri");
        if (confCollectionURI == null) {
            this.collectionURI = DEFAULT_URI;
        } else {
            try {
                this.collectionURI = XmldbURI.xmldbUriFor((String)confCollectionURI);
            }
            catch (URISyntaxException e) {
                throw new ServletException("Invalid XmldbURI for parameter 'uri': " + e.getMessage(), (Throwable)e);
            }
        }
        this.encoding = config.getInitParameter("encoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.getLog().info("encoding = " + this.encoding);
        this.contentType = config.getInitParameter("content-type");
        if (this.contentType == null) {
            this.contentType = DEFAULT_CONTENT_TYPE;
        }
        this.hideErrorMessages = Optional.ofNullable(config.getInitParameter("hide-error-messages")).map(Boolean::parseBoolean).orElse(false);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest request = null;
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        request = descriptor != null ? (descriptor.allowRequestLogging() ? new HttpServletRequestWrapper(req, this.getFormEncoding()) : req) : req;
        this.process(request, response);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest request = null;
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        request = descriptor != null ? (descriptor.allowRequestLogging() ? new HttpServletRequestWrapper(req, this.getFormEncoding()) : req) : req;
        this.process(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object loadPathAttrib;
        Descriptor descriptor;
        String path = request.getPathTranslated();
        if (path == null) {
            path = request.getRequestURI().substring(request.getContextPath().length());
            int p = path.lastIndexOf(59);
            if (p != -1) {
                path = path.substring(0, p);
            }
            path = this.getServletContext().getRealPath(path);
        }
        if ((descriptor = Descriptor.getDescriptorSingleton()) != null && !descriptor.requestsFiltered()) {
            descriptor.doLogRequestInReplayLog(request);
            path = descriptor.mapPath(path);
        }
        ServletOutputStream sout = response.getOutputStream();
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)sout, this.getFormEncoding()));
        response.addHeader("pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        String requestPath = request.getRequestURI();
        int p = requestPath.lastIndexOf("/");
        if (p != -1) {
            requestPath = requestPath.substring(0, p);
        }
        String moduleLoadPath = (loadPathAttrib = request.getAttribute(ATTR_MODULE_LOAD_PATH)) != null ? this.getValue(loadPathAttrib) : this.getServletContext().getRealPath(requestPath.substring(request.getContextPath().length()));
        Subject user = this.getDefaultUser();
        Object userAttrib = request.getAttribute(ATTR_XQUERY_USER);
        HttpSession session = request.getSession(false);
        if (userAttrib != null || session != null && request.isRequestedSessionIdValid()) {
            String password;
            String username;
            Object passwdAttrib = request.getAttribute(ATTR_XQUERY_PASSWORD);
            if (userAttrib != null) {
                username = this.getValue(userAttrib);
                password = this.getValue(passwdAttrib);
            } else {
                username = this.getSessionAttribute(session, "user");
                password = this.getSessionAttribute(session, "password");
            }
            try {
                Subject newUser;
                if (username != null && password != null && (newUser = this.getPool().getSecurityManager().authenticate(username, (Object)password)) != null && newUser.isAuthenticated()) {
                    user = newUser;
                }
            }
            catch (AuthenticationException e) {
                this.getLog().error("User can not be authenticated (" + username + ").");
            }
        }
        if (user == this.getDefaultUser()) {
            Subject requestUser = HttpAccount.getUserFromServletRequest((HttpServletRequest)request);
            if (requestUser != null) {
                user = requestUser;
            } else {
                requestUser = this.getAuthenticator().authenticate(request, response, false);
                if (requestUser != null) {
                    user = requestUser;
                }
            }
        }
        StringSource source = null;
        Object sourceAttrib = request.getAttribute(ATTR_XQUERY_SOURCE);
        Object urlAttrib = request.getAttribute(ATTR_XQUERY_URL);
        if (sourceAttrib != null) {
            String s;
            if (sourceAttrib instanceof Item) {
                try {
                    s = ((Item)sourceAttrib).getStringValue();
                }
                catch (XPathException e) {
                    throw new ServletException("Failed to read XQuery source string from request attribute 'xquery.source': " + e.getMessage(), (Throwable)e);
                }
            } else {
                s = sourceAttrib.toString();
            }
            source = new StringSource(s);
        } else if (urlAttrib != null) {
            try (DBBroker broker = this.getPool().get(Optional.ofNullable(user));){
                source = SourceFactory.getSource((DBBroker)broker, (String)moduleLoadPath, (String)urlAttrib.toString(), (boolean)true);
            }
            catch (Exception e) {
                this.getLog().error(e.getMessage(), (Throwable)e);
                response.setStatus(500);
                this.sendError(output, "Error", e.getMessage());
            }
        } else {
            Path f = Paths.get(path, new String[0]);
            if (!Files.isReadable(f)) {
                response.setStatus(404);
                this.sendError(output, "Cannot read source file", path);
                return;
            }
            source = new FileSource(f, Charset.forName(this.encoding), true);
        }
        if (source == null) {
            response.setStatus(404);
            this.sendError(output, "Source not found", path);
        }
        boolean reportErrors = false;
        String errorOpt = (String)request.getAttribute(ATTR_XQUERY_REPORT_ERRORS);
        if (errorOpt != null) {
            reportErrors = errorOpt.equalsIgnoreCase("YES");
        }
        if ("GET".equals(request.getMethod().toUpperCase())) {
            boolean allowSource = false;
            String option = request.getParameter("_source");
            if (option != null) {
                allowSource = "yes".equals(option);
            }
            if (allowSource && descriptor != null) {
                if (descriptor.allowSource(path)) {
                    try {
                        source.validate(user, 4);
                    }
                    catch (PermissionDeniedException e) {
                        if (this.getDefaultUser().equals(user)) {
                            this.getAuthenticator().sendChallenge(request, response);
                        } else {
                            response.sendError(403, "Permission to view XQuery source for: " + path + " denied. (no read access)");
                        }
                        return;
                    }
                    response.setContentType("text/plain; charset=" + this.getFormEncoding());
                    output.write(source.getContent());
                    output.flush();
                    return;
                }
                response.sendError(403, "Permission to view XQuery source for: " + path + " denied. Must be explicitly defined in descriptor.xml");
                return;
            }
        }
        String requestAttr = (String)request.getAttribute(ATTR_XQUERY_ATTRIBUTE);
        try (DBBroker broker = this.getPool().get(Optional.ofNullable(user));){
            Sequence resultSequence;
            String maxNodesOpt;
            XQueryContext context;
            XQuery xquery = broker.getBrokerPool().getXQueryService();
            CompiledXQuery query = this.getPool().getXQueryPool().borrowCompiledXQuery(broker, (Source)source);
            if (query == null) {
                context = new XQueryContext((Database)this.getPool());
                context.setModuleLoadPath(moduleLoadPath);
                try {
                    query = xquery.compile(broker, context, (Source)source);
                }
                catch (XPathException ex) {
                    throw new EXistException("Cannot compile xquery: " + ex.getMessage(), (Throwable)ex);
                }
                catch (IOException ex) {
                    throw new EXistException("I/O exception while compiling xquery: " + ex.getMessage(), (Throwable)ex);
                }
            } else {
                context = query.getContext();
                context.setModuleLoadPath(moduleLoadPath);
            }
            Properties outputProperties = new Properties();
            outputProperties.put("base-uri", this.collectionURI.toString());
            context.declareVariable("request:request", (Object)new HttpRequestWrapper(request, this.getFormEncoding(), this.getContainerEncoding()));
            context.declareVariable("response:response", (Object)new HttpResponseWrapper(response));
            context.declareVariable("session:session", (Object)(session != null ? new HttpSessionWrapper(session) : null));
            String timeoutOpt = (String)request.getAttribute(ATTR_TIMEOUT);
            if (timeoutOpt != null) {
                try {
                    long timeout = Long.parseLong(timeoutOpt);
                    context.getWatchDog().setTimeout(timeout);
                }
                catch (NumberFormatException e) {
                    throw new EXistException("Bad timeout option: " + timeoutOpt);
                }
            }
            if ((maxNodesOpt = (String)request.getAttribute(ATTR_MAX_NODES)) != null) {
                try {
                    int maxNodes = Integer.parseInt(maxNodesOpt);
                    context.getWatchDog().setMaxNodes(maxNodes);
                }
                catch (NumberFormatException e) {
                    throw new EXistException("Bad max-nodes option: " + maxNodesOpt);
                }
            }
            DebuggeeFactory.checkForDebugRequest((HttpServletRequest)request, (XQueryContext)context);
            try {
                resultSequence = xquery.execute(broker, query, null, outputProperties);
            }
            finally {
                context.runCleanupTasks();
                this.getPool().getXQueryPool().returnCompiledXQuery((Source)source, query);
            }
            String mediaType = outputProperties.getProperty("media-type");
            if (mediaType != null) {
                if (!response.isCommitted()) {
                    if (MimeTable.getInstance().isTextContent(mediaType)) {
                        response.setContentType(mediaType + "; charset=" + this.getFormEncoding());
                        response.setCharacterEncoding(this.getFormEncoding());
                    } else {
                        response.setContentType(mediaType);
                    }
                }
            } else {
                String contentType = this.contentType;
                try {
                    contentType = this.getServletContext().getMimeType(path);
                    if (contentType == null) {
                        contentType = this.contentType;
                    }
                }
                catch (Throwable e) {
                    contentType = this.contentType;
                }
                finally {
                    if (MimeTable.getInstance().isTextContent(contentType)) {
                        contentType = contentType + "; charset=" + this.getFormEncoding();
                    }
                    response.setContentType(contentType);
                }
            }
            if (requestAttr != null && "local".equals(this.collectionURI.getApiName())) {
                request.setAttribute(requestAttr, (Object)resultSequence);
            } else {
                XQuerySerializer serializer = new XQuerySerializer(broker, outputProperties, (Writer)output);
                serializer.serialize(resultSequence);
            }
        }
        catch (PermissionDeniedException e) {
            if (this.getDefaultUser().equals(user)) {
                this.getAuthenticator().sendChallenge(request, response);
            } else {
                response.sendError(403, "No permission to execute XQuery for: " + path + " denied.");
            }
            return;
        }
        catch (XPathException e) {
            Logger logger = this.getLog();
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            if (reportErrors) {
                this.writeError(output, e);
            } else {
                response.setStatus(500);
                this.sendError(output, "Error", e.getMessage());
            }
        }
        catch (Throwable e) {
            this.getLog().error(e.getMessage(), e);
            if (reportErrors) {
                this.writeError(output, e);
            }
            response.setStatus(500);
            this.sendError(output, "Error", e.getMessage());
        }
        output.flush();
        output.close();
    }

    private String getSessionAttribute(HttpSession session, String attribute) {
        Object obj = session.getAttribute(attribute);
        return this.getValue(obj);
    }

    private String getValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Sequence) {
            try {
                return ((Sequence)obj).getStringValue();
            }
            catch (XPathException e) {
                return null;
            }
        }
        return obj.toString();
    }

    private void writeError(PrintWriter out, Throwable e) {
        out.print("<error>");
        if (e.getMessage() != null && !this.hideErrorMessages) {
            out.print(XMLUtil.encodeAttrMarkup((String)e.getMessage()));
        }
        out.println("</error>");
    }

    private void sendError(PrintWriter out, String message, String description) {
        out.print("<html><head>");
        out.print("<title>XQueryServlet Error</title>");
        out.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"error.css\"></link></head>");
        out.println("<body><h1>Error found</h1>");
        out.print("<div class='message'><b>Message: </b>");
        out.print(message);
        out.print("</div>");
        if (!this.hideErrorMessages) {
            out.print("<div class='description'><pre>");
            out.print(description);
            out.print("</pre></div>");
        }
        out.print("</body></html>");
        out.flush();
    }
}

