/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.urlrewrite;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.urlrewrite.URLRewrite;
import org.exist.interpreter.Context;
import org.exist.xquery.ContextItemDeclaration;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Element;

public class ModuleCall
extends URLRewrite {
    private static final Logger LOG = LogManager.getLogger(ModuleCall.class);
    private FunctionCall call;

    public ModuleCall(Element config, XQueryContext context, String uri) throws ServletException {
        super(config, uri);
        String funcName = config.getAttribute("function");
        if (funcName == null || funcName.length() == 0) {
            throw new ServletException("<exist:call> requires an attribute 'function'.");
        }
        int arity = 0;
        int p = funcName.indexOf(47);
        if (p > -1) {
            String arityStr = funcName.substring(p + 1);
            try {
                arity = Integer.parseInt(arityStr);
            }
            catch (NumberFormatException e) {
                throw new ServletException("<exist:call>: could not parse parameter count in function attribute: " + arityStr);
            }
            funcName = funcName.substring(0, p);
        }
        try {
            QName fqn = QName.parse((Context)context, (String)funcName);
            Module module = context.getModule(fqn.getNamespaceURI());
            UserDefinedFunction func = null;
            func = module != null ? ((ExternalModule)module).getFunction(fqn, arity, context) : context.resolveFunction(fqn, arity);
            this.call = new FunctionCall(context, func);
            this.call.setArguments(new ArrayList());
        }
        catch (QName.IllegalQNameException | XPathException e) {
            e.printStackTrace();
        }
    }

    protected ModuleCall(ModuleCall other) {
        super(other);
        this.call = other.call;
    }

    @Override
    public void doRewrite(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ContextItemDeclaration cid = this.call.getContext().getContextItemDeclartion();
            Sequence contextSequence = cid != null ? cid.eval(null) : null;
            Sequence result = this.call.eval(contextSequence);
            LOG.debug("Found: " + result.getItemCount());
            request.setAttribute("org.exist.forward.result", (Object)result);
        }
        catch (XPathException e) {
            throw new ServletException("Called function threw exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected URLRewrite copy() {
        return new ModuleCall(this);
    }
}

