/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.urlrewrite;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.http.urlrewrite.URLRewrite;
import org.w3c.dom.Element;

public class Redirect
extends URLRewrite {
    public Redirect(Element config, String uri) throws ServletException {
        super(config, uri);
        String redirectTo = config.getAttribute("url");
        if (redirectTo.length() == 0) {
            throw new ServletException("<exist:redirect> needs an attribute 'url'.");
        }
        if (redirectTo.matches("^\\w+://.*")) {
            this.setTarget(redirectTo);
        } else {
            this.setTarget(URLRewrite.normalizePath(redirectTo));
        }
    }

    public Redirect(Redirect other) {
        super(other);
    }

    @Override
    public void doRewrite(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setHeaders(new HttpResponseWrapper(response));
        response.sendRedirect(this.target);
    }

    @Override
    protected URLRewrite copy() {
        return new Redirect(this);
    }
}

