/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.urlrewrite;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.http.urlrewrite.ControllerForward;
import org.exist.http.urlrewrite.PathForward;
import org.exist.http.urlrewrite.Redirect;
import org.exist.http.urlrewrite.URLRewrite;
import org.exist.http.urlrewrite.XQueryURLRewrite;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.regex.JDK15RegexTranslator;
import org.exist.xquery.regex.RegexSyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RewriteConfig {
    public static final String CONFIG_FILE = "controller-config.xml";
    public static final String MAP_ELEMENT = "map";
    public static final String PATTERN_ATTRIBUTE = "pattern";
    public static final String SERVER_NAME_ATTRIBUTE = "server-name";
    private static final Logger LOG = LogManager.getLogger(RewriteConfig.class);
    private List<Mapping> mappings = new ArrayList<Mapping>();
    private XQueryURLRewrite urlRewrite;

    public RewriteConfig(XQueryURLRewrite urlRewrite) throws ServletException {
        this.urlRewrite = urlRewrite;
        String controllerConfig = urlRewrite.getConfig().getInitParameter("config");
        if (controllerConfig == null) {
            controllerConfig = CONFIG_FILE;
        }
        this.configure(controllerConfig);
    }

    public synchronized URLRewrite lookup(HttpServletRequest request) throws ServletException {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        return this.lookup(path, request.getServerName(), false, null);
    }

    public synchronized URLRewrite lookup(String path, String serverName, boolean staticMapping, URLRewrite copyFrom) throws ServletException {
        int p = path.lastIndexOf(59);
        if (p != -1) {
            path = path.substring(0, p);
        }
        for (int i = 0; i < this.mappings.size(); ++i) {
            String controllerServerName;
            Mapping m = this.mappings.get(i);
            String matchedString = m.match(path);
            if (matchedString == null) continue;
            URLRewrite action = m.action.copy();
            if (copyFrom != null) {
                action.copyFrom(copyFrom);
            }
            if (action instanceof ControllerForward && serverName != null && (controllerServerName = ((ControllerForward)action).getServerName()) != null && !serverName.equalsIgnoreCase(controllerServerName)) continue;
            if (matchedString.length() != path.length() && !"/".equals(matchedString)) {
                action.setPrefix(matchedString);
            }
            action.setURI(path);
            if (staticMapping && action instanceof ControllerForward) continue;
            return action;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(String controllerConfig) throws ServletException {
        block28: {
            LOG.debug("Loading XQueryURLRewrite configuration from " + controllerConfig);
            if (controllerConfig.startsWith("xmldb:")) {
                try (DBBroker broker = this.urlRewrite.pool.get(Optional.ofNullable(this.urlRewrite.defaultUser));){
                    DocumentImpl doc = null;
                    try {
                        doc = broker.getXMLResource(XmldbURI.create((String)controllerConfig), Lock.LockMode.READ_LOCK);
                        if (doc != null) {
                            this.parse((Document)doc);
                        }
                        break block28;
                    }
                    finally {
                        if (doc != null) {
                            doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        }
                    }
                }
                catch (EXistException e) {
                    throw new ServletException("Failed to parse controller.xml: " + e.getMessage(), (Throwable)e);
                }
                catch (PermissionDeniedException e) {
                    throw new ServletException("Failed to parse controller.xml: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                Path d = Paths.get(this.urlRewrite.getConfig().getServletContext().getRealPath("/"), new String[0]).normalize();
                Path configFile = d.resolve(controllerConfig);
                if (Files.isReadable(configFile)) {
                    Document doc = this.parseConfig(configFile);
                    this.parse(doc);
                }
            }
            catch (ParserConfigurationException e) {
                throw new ServletException("Failed to parse controller.xml: " + e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                throw new ServletException("Failed to parse controller.xml: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ServletException("Failed to parse controller.xml: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.urlRewrite.clearCaches();
        }
        catch (EXistException e) {
            throw new ServletException("Failed to update controller.xml: " + e.getMessage(), (Throwable)e);
        }
    }

    private void parse(Document doc) throws ServletException {
        Element root = doc.getDocumentElement();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            String ns = child.getNamespaceURI();
            if (child.getNodeType() != 1 || ns == null || !ns.equals("http://exist.sourceforge.net/NS/exist")) continue;
            Element elem = (Element)child;
            String pattern = elem.getAttribute(PATTERN_ATTRIBUTE);
            if (pattern == null) {
                throw new ServletException("Action in controller-config.xml has no pattern: " + elem.toString());
            }
            URLRewrite urw = this.parseAction(this.urlRewrite.getConfig(), pattern, elem);
            if (urw == null) {
                throw new ServletException("Unknown action in controller-config.xml: " + elem.getNodeName());
            }
            this.mappings.add(new Mapping(pattern, urw));
        }
    }

    private URLRewrite parseAction(ServletConfig config, String pattern, Element action) throws ServletException {
        URLRewrite rewrite = null;
        if ("forward".equals(action.getLocalName())) {
            rewrite = new PathForward(config, action, pattern);
        } else if ("redirect".equals(action.getLocalName())) {
            rewrite = new Redirect(action, pattern);
        } else if ("root".equals(action.getLocalName())) {
            ControllerForward cf = new ControllerForward(action, pattern);
            String serverName = action.getAttribute(SERVER_NAME_ATTRIBUTE);
            if (serverName != null && serverName.length() > 0) {
                cf.setServerName(serverName);
            }
            rewrite = cf;
        }
        return rewrite;
    }

    private Document parseConfig(Path file) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            InputSource src = new InputSource(is);
            SAXParser parser = factory.newSAXParser();
            XMLReader xr = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter();
            xr.setContentHandler((ContentHandler)adapter);
            xr.setProperty("http://xml.org/sax/properties/lexical-handler", adapter);
            xr.parse(src);
            org.exist.dom.memtree.DocumentImpl documentImpl = adapter.getDocument();
            return documentImpl;
        }
    }

    private static final class Mapping {
        Pattern pattern;
        Matcher matcher = null;
        URLRewrite action;

        private Mapping(String regex, URLRewrite action) throws ServletException {
            try {
                int xmlVersion = 11;
                boolean ignoreWhitespace = false;
                boolean caseBlind = false;
                regex = JDK15RegexTranslator.translate((CharSequence)regex, (int)11, (boolean)true, (boolean)false, (boolean)false);
                this.pattern = Pattern.compile(regex, 0);
                this.action = action;
            }
            catch (RegexSyntaxException e) {
                throw new ServletException("Syntax error in regular expression specified for path. " + e.getMessage(), (Throwable)e);
            }
        }

        public String match(String path) {
            if (this.matcher == null) {
                this.matcher = this.pattern.matcher(path);
            } else {
                this.matcher.reset(path);
            }
            if (this.matcher.lookingAt()) {
                return path.substring(this.matcher.start(), this.matcher.end());
            }
            return null;
        }
    }
}

