/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.urlrewrite;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ReadListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.http.Descriptor;
import org.exist.http.servlets.Authenticator;
import org.exist.http.servlets.BasicAuthenticator;
import org.exist.http.servlets.HttpRequestWrapper;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.http.urlrewrite.PassThrough;
import org.exist.http.urlrewrite.PathForward;
import org.exist.http.urlrewrite.Redirect;
import org.exist.http.urlrewrite.RewriteConfig;
import org.exist.http.urlrewrite.URLRewrite;
import org.exist.security.AuthenticationException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.security.internal.web.HttpAccount;
import org.exist.source.DBSource;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.util.MimeType;
import org.exist.util.serializer.XQuerySerializer;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmldb.api.DatabaseManager;

public class XQueryURLRewrite
extends HttpServlet {
    private static final Logger LOG = LogManager.getLogger(XQueryURLRewrite.class);
    public static final String RQ_ATTR = "org.exist.forward";
    public static final String RQ_ATTR_REQUEST_URI = "org.exist.forward.request-uri";
    public static final String RQ_ATTR_SERVLET_PATH = "org.exist.forward.servlet-path";
    public static final String RQ_ATTR_RESULT = "org.exist.forward.result";
    public static final String RQ_ATTR_ERROR = "org.exist.forward.error";
    public static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    private static final Pattern NAME_REGEX = Pattern.compile("^.*/([^/]+)$", 0);
    private ServletConfig config;
    private final Map<String, ModelAndView> urlCache = Collections.synchronizedMap(new TreeMap());
    protected Subject defaultUser = null;
    protected BrokerPool pool;
    private String query = null;
    private boolean compiledCache = true;
    private RewriteConfig rewriteConfig;
    private Authenticator authenticator;

    public void init(ServletConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.query = filterConfig.getInitParameter("xquery");
        String opt = filterConfig.getInitParameter("compiled-cache");
        if (opt != null) {
            this.compiledCache = opt != null && opt.equalsIgnoreCase("true");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        String attr;
        Descriptor descriptor;
        if (this.rewriteConfig == null) {
            this.configure();
            this.rewriteConfig = new RewriteConfig(this);
        }
        long start = System.currentTimeMillis();
        HttpServletRequest request = servletRequest;
        HttpServletResponse response = servletResponse;
        if (LOG.isTraceEnabled()) {
            LOG.trace(request.getRequestURI());
        }
        if ((descriptor = Descriptor.getDescriptorSingleton()) != null && descriptor.requestsFiltered() && (attr = (String)request.getAttribute("XQueryURLRewrite.forwarded")) == null) {
            descriptor.doLogRequestInReplayLog(request);
            request.setAttribute("XQueryURLRewrite.forwarded", (Object)"true");
        }
        Subject user = this.defaultUser;
        Subject requestUser = HttpAccount.getUserFromServletRequest((HttpServletRequest)request);
        if (requestUser != null) {
            user = requestUser;
        } else {
            String auth = request.getHeader("Authorization");
            if (auth != null && (requestUser = this.authenticator.authenticate(request, response)) != null) {
                user = requestUser;
            }
        }
        try {
            ModelAndView modelView;
            URLRewrite staticRewrite;
            RequestWrapper modifiedRequest;
            block66: {
                this.configure();
                modifiedRequest = new RequestWrapper(request);
                staticRewrite = this.rewriteConfig.lookup((HttpServletRequest)modifiedRequest);
                if (staticRewrite != null && !staticRewrite.isControllerForward()) {
                    modifiedRequest.setPaths(staticRewrite.resolve(modifiedRequest), staticRewrite.getPrefix());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Forwarding to target: " + staticRewrite.getTarget());
                    }
                    staticRewrite.doRewrite((HttpServletRequest)modifiedRequest, response);
                    return;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing request URI: " + request.getRequestURI());
                }
                if (staticRewrite != null) {
                    staticRewrite.updateRequest(modifiedRequest);
                }
                modelView = this.getFromCache(request.getHeader("Host") + request.getRequestURI(), user);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checked cache for URI: " + modifiedRequest.getRequestURI() + " original: " + request.getRequestURI());
                }
                if (modelView != null) break block66;
                modelView = new ModelAndView();
                Sequence result = Sequence.EMPTY_SEQUENCE;
                try (DBBroker broker = this.pool.get(Optional.ofNullable(user));){
                    block70: {
                        Element elem;
                        Node node;
                        block69: {
                            Properties outputProperties;
                            block67: {
                                String nsUri;
                                block68: {
                                    modifiedRequest.setAttribute(RQ_ATTR_REQUEST_URI, request.getRequestURI());
                                    outputProperties = new Properties();
                                    outputProperties.setProperty("indent", "yes");
                                    outputProperties.setProperty("encoding", "UTF-8");
                                    outputProperties.setProperty("media-type", MimeType.XML_TYPE.getName());
                                    result = this.runQuery(broker, modifiedRequest, response, modelView, staticRewrite, outputProperties);
                                    this.logResult(broker, result);
                                    if (response.isCommitted()) {
                                        return;
                                    }
                                    if (result.getItemCount() != 1) break block67;
                                    Item resource = result.itemAt(0);
                                    if (!Type.subTypeOf((int)resource.getType(), (int)-1)) {
                                        throw new ServletException("XQueryURLRewrite: urlrewrite query should return an element!");
                                    }
                                    node = ((NodeValue)resource).getNode();
                                    if (node.getNodeType() == 9) {
                                        node = ((Document)node).getDocumentElement();
                                    }
                                    if (node.getNodeType() != 1) {
                                        this.response(broker, response, outputProperties, result);
                                        return;
                                    }
                                    elem = (Element)node;
                                    String ns = elem.getNamespaceURI();
                                    if (ns == null || !"http://exist.sourceforge.net/NS/exist".equals(ns)) {
                                        this.response(broker, response, outputProperties, result);
                                        return;
                                    }
                                    nsUri = elem.getNamespaceURI();
                                    if (nsUri == null || !"http://exist.sourceforge.net/NS/exist".equals(nsUri) || !"dispatch".equals(elem.getLocalName())) break block68;
                                    break block69;
                                }
                                if (nsUri != null && "http://exist.sourceforge.net/NS/exist".equals(elem.getNamespaceURI()) && "ignore".equals(elem.getLocalName())) {
                                    modelView.setModel(new PassThrough(this.config, elem, (HttpServletRequest)modifiedRequest));
                                    NodeList nl = elem.getElementsByTagNameNS("http://exist.sourceforge.net/NS/exist", "cache-control");
                                    if (nl.getLength() > 0) {
                                        elem = (Element)nl.item(0);
                                        String option = elem.getAttribute("cache");
                                        modelView.setUseCache("yes".equals(option));
                                    }
                                    break block70;
                                } else {
                                    this.response(broker, response, outputProperties, result);
                                    return;
                                }
                            }
                            if (result.getItemCount() > 1) {
                                this.response(broker, response, outputProperties, result);
                                return;
                            }
                            break block70;
                        }
                        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                            String nodeNs = node.getNamespaceURI();
                            if (node.getNodeType() != 1 || nodeNs == null || !"http://exist.sourceforge.net/NS/exist".equals(nodeNs)) continue;
                            Element action = (Element)node;
                            if ("view".equals(action.getLocalName())) {
                                this.parseViews((HttpServletRequest)modifiedRequest, action, modelView);
                                continue;
                            }
                            if ("error-handler".equals(action.getLocalName())) {
                                this.parseErrorHandlers((HttpServletRequest)modifiedRequest, action, modelView);
                                continue;
                            }
                            if ("cache-control".equals(action.getLocalName())) {
                                String option = action.getAttribute("cache");
                                modelView.setUseCache("yes".equals(option));
                                continue;
                            }
                            URLRewrite urw = this.parseAction((HttpServletRequest)modifiedRequest, action);
                            if (urw == null) continue;
                            modelView.setModel(urw);
                        }
                        if (modelView.getModel() == null) {
                            modelView.setModel(new PassThrough(this.config, elem, (HttpServletRequest)modifiedRequest));
                        }
                    }
                    if (modelView.useCache()) {
                        LOG.debug("Caching request to " + request.getRequestURI());
                        this.urlCache.put(modifiedRequest.getHeader("Host") + request.getRequestURI(), modelView);
                    }
                }
                modifiedRequest.setAttribute(RQ_ATTR_REQUEST_URI, request.getRequestURI());
                modifiedRequest.setAttribute(RQ_ATTR_SERVLET_PATH, request.getServletPath());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("URLRewrite took " + (System.currentTimeMillis() - start) + "ms.");
            }
            CachingResponseWrapper wrappedResponse = new CachingResponseWrapper(response, modelView.hasViews() || modelView.hasErrorHandlers());
            if (modelView.getModel() == null) {
                modelView.setModel(new PassThrough(this.config, (HttpServletRequest)modifiedRequest));
            }
            if (staticRewrite != null) {
                if (modelView.getModel().doResolve()) {
                    staticRewrite.rewriteRequest(modifiedRequest);
                } else {
                    modelView.getModel().setAbsolutePath(modifiedRequest);
                }
            }
            modifiedRequest.allowCaching(!modelView.hasViews());
            this.doRewrite(modelView.getModel(), modifiedRequest, (HttpServletResponse)wrappedResponse);
            int status = wrappedResponse.getStatus();
            if (status == 304) {
                response.flushBuffer();
                return;
            }
            if (status < 400) {
                if (modelView.hasViews()) {
                    this.applyViews(modelView, modelView.views, response, modifiedRequest, (HttpServletResponse)wrappedResponse);
                    return;
                }
                wrappedResponse.flush();
                return;
            }
            if (!modelView.hasErrorHandlers()) {
                this.flushError(response, (HttpServletResponse)wrappedResponse);
                return;
            }
            byte[] data = wrappedResponse.getData();
            if (data != null) {
                modifiedRequest.setAttribute(RQ_ATTR_ERROR, new String(data, StandardCharsets.UTF_8));
            }
            this.applyViews(modelView, modelView.errorHandlers, response, modifiedRequest, (HttpServletResponse)wrappedResponse);
            return;
        }
        catch (Throwable e) {
            LOG.error("Error while processing " + servletRequest.getRequestURI() + ": " + e.getMessage(), e);
            throw new ServletException("An error occurred while processing request to " + servletRequest.getRequestURI() + ": " + e.getMessage(), e);
        }
    }

    private void applyViews(ModelAndView modelView, List<URLRewrite> views, HttpServletResponse response, RequestWrapper modifiedRequest, HttpServletResponse currentResponse) throws IOException, ServletException {
        Object wrappedResponse = currentResponse;
        for (int i = 0; i < views.size(); ++i) {
            URLRewrite view = views.get(i);
            byte[] data = ((CachingResponseWrapper)((Object)wrappedResponse)).getData();
            String method = view.getMethod();
            if (method == null) {
                method = "POST";
            }
            RequestWrapper wrappedReq = new RequestWrapper((HttpServletRequest)modifiedRequest);
            wrappedReq.allowCaching(false);
            wrappedReq.setMethod(method);
            wrappedReq.setBasePath(modifiedRequest.getBasePath());
            wrappedReq.setCharacterEncoding(wrappedResponse.getCharacterEncoding());
            wrappedReq.setContentType(wrappedResponse.getContentType());
            if (data != null) {
                wrappedReq.setData(data);
            }
            wrappedResponse = new CachingResponseWrapper(response, true);
            this.doRewrite(view, wrappedReq, (HttpServletResponse)wrappedResponse);
            int status = ((CachingResponseWrapper)((Object)wrappedResponse)).getStatus();
            if (status >= 400) {
                if (modelView != null && modelView.hasErrorHandlers()) {
                    data = ((CachingResponseWrapper)((Object)wrappedResponse)).getData();
                    String msg = data == null ? "" : new String(data, StandardCharsets.UTF_8);
                    modifiedRequest.setAttribute(RQ_ATTR_ERROR, msg);
                    this.applyViews(null, modelView.errorHandlers, response, modifiedRequest, (HttpServletResponse)wrappedResponse);
                    break;
                }
                this.flushError(response, (HttpServletResponse)wrappedResponse);
                break;
            }
            if (i != views.size() - 1) continue;
            ((CachingResponseWrapper)((Object)wrappedResponse)).flush();
        }
    }

    private void response(DBBroker broker, HttpServletResponse response, Properties outputProperties, Sequence resultSequence) throws IOException {
        String mimeType;
        String encoding = outputProperties.getProperty("encoding");
        ServletOutputStream sout = response.getOutputStream();
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)sout, encoding));
        if (!response.containsHeader("Content-Type") && (mimeType = outputProperties.getProperty("media-type")) != null) {
            int semicolon = mimeType.indexOf(59);
            if (semicolon != -1) {
                mimeType = mimeType.substring(0, semicolon);
            }
            response.setContentType(mimeType + "; charset=" + encoding);
        }
        try {
            XQuerySerializer serializer = new XQuerySerializer(broker, outputProperties, (Writer)output);
            serializer.serialize(resultSequence);
        }
        catch (XPathException | SAXException e) {
            throw new IOException(e);
        }
        output.flush();
        output.close();
    }

    private void flushError(HttpServletResponse response, HttpServletResponse wrappedResponse) throws IOException {
        byte[] data;
        if (!response.isCommitted() && (data = ((CachingResponseWrapper)wrappedResponse).getData()) != null) {
            response.setContentType(wrappedResponse.getContentType());
            response.setCharacterEncoding(wrappedResponse.getCharacterEncoding());
            response.getOutputStream().write(data);
            response.flushBuffer();
        }
    }

    private ModelAndView getFromCache(String url, Subject user) throws EXistException, ServletException, PermissionDeniedException {
        ModelAndView model = this.urlCache.get(url);
        if (model == null) {
            return null;
        }
        try (DBBroker broker = this.pool.get(Optional.ofNullable(user));){
            model.getSourceInfo().source.validate(broker.getCurrentSubject(), 1);
            if (model.getSourceInfo().source.isValid(broker) != Source.Validity.VALID) {
                this.urlCache.remove(url);
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using cached entry for " + url);
            }
            ModelAndView modelAndView = model;
            return modelAndView;
        }
    }

    protected void clearCaches() throws EXistException {
        this.urlCache.clear();
    }

    protected void doRewrite(URLRewrite action, RequestWrapper request, HttpServletResponse response) throws IOException, ServletException {
        String uri;
        URLRewrite staticRewrite;
        if (action.getTarget() != null && !(action instanceof Redirect) && (staticRewrite = this.rewriteConfig.lookup(uri = action.resolve(request), request.getServerName(), true, action)) != null) {
            staticRewrite.copyFrom(action);
            action = staticRewrite;
            RequestWrapper modifiedRequest = new RequestWrapper((HttpServletRequest)request);
            modifiedRequest.setPaths(uri, action.getPrefix());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Forwarding to : " + action.toString() + " url: " + action.getURI());
            }
            request = modifiedRequest;
        }
        action.prepareRequest(request);
        action.doRewrite((HttpServletRequest)request, response);
    }

    protected ServletConfig getConfig() {
        return this.config;
    }

    private URLRewrite parseAction(HttpServletRequest request, Element action) throws ServletException {
        URLRewrite rewrite = null;
        if ("forward".equals(action.getLocalName())) {
            rewrite = new PathForward(this.config, action, request.getRequestURI());
        } else if ("redirect".equals(action.getLocalName())) {
            rewrite = new Redirect(action, request.getRequestURI());
        }
        return rewrite;
    }

    private void parseViews(HttpServletRequest request, Element view, ModelAndView modelView) throws ServletException {
        for (Node node = view.getFirstChild(); node != null; node = node.getNextSibling()) {
            URLRewrite urw;
            String ns = node.getNamespaceURI();
            if (node.getNodeType() != 1 || ns == null || !"http://exist.sourceforge.net/NS/exist".equals(ns) || (urw = this.parseAction(request, (Element)node)) == null) continue;
            modelView.addView(urw);
        }
    }

    private void parseErrorHandlers(HttpServletRequest request, Element view, ModelAndView modelView) throws ServletException {
        for (Node node = view.getFirstChild(); node != null; node = node.getNextSibling()) {
            URLRewrite urw;
            String ns = node.getNamespaceURI();
            if (node.getNodeType() != 1 || ns == null || !"http://exist.sourceforge.net/NS/exist".equals(ns) || (urw = this.parseAction(request, (Element)node)) == null) continue;
            modelView.addErrorHandler(urw);
        }
    }

    private void configure() throws ServletException {
        if (this.pool != null) {
            return;
        }
        try {
            Class<?> driver = Class.forName(DRIVER);
            org.xmldb.api.base.Database database = (org.xmldb.api.base.Database)driver.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((org.xmldb.api.base.Database)database);
            LOG.debug("Initialized database");
        }
        catch (Exception e) {
            String errorMessage = "Failed to initialize database driver";
            LOG.error("Failed to initialize database driver", (Throwable)e);
            throw new ServletException("Failed to initialize database driver: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.pool = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            throw new ServletException("Could not intialize db: " + e.getMessage(), (Throwable)e);
        }
        this.defaultUser = this.pool.getSecurityManager().getGuestSubject();
        String username = this.config.getInitParameter("user");
        if (username != null) {
            String password = this.config.getInitParameter("password");
            try {
                Subject user = this.pool.getSecurityManager().authenticate(username, (Object)password);
                if (user != null && user.isAuthenticated()) {
                    this.defaultUser = user;
                }
            }
            catch (AuthenticationException e) {
                LOG.error("User can not be authenticated (" + username + "), using default user.");
            }
        }
        this.authenticator = new BasicAuthenticator(this.pool);
    }

    private void logResult(DBBroker broker, Sequence result) throws IOException, SAXException {
        if (LOG.isTraceEnabled() && result.getItemCount() > 0) {
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            Item item = result.itemAt(0);
            if (Type.subTypeOf((int)item.getType(), (int)-1)) {
                LOG.trace(serializer.serialize((NodeValue)item));
            }
        }
    }

    public void destroy() {
        this.config = null;
    }

    private SourceInfo getSourceInfo(DBBroker broker, RequestWrapper request, URLRewrite staticRewrite) throws ServletException {
        String basePath;
        String moduleLoadPath = this.config.getServletContext().getRealPath("/");
        String string = basePath = staticRewrite == null ? "." : staticRewrite.getTarget();
        if (basePath == null) {
            return this.getSource(broker, moduleLoadPath);
        }
        return this.findSource((HttpServletRequest)request, broker, basePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence runQuery(DBBroker broker, RequestWrapper request, HttpServletResponse response, ModelAndView model, URLRewrite staticRewrite, Properties outputProperties) throws ServletException, XPathException, PermissionDeniedException {
        SourceInfo sourceInfo = this.getSourceInfo(broker, request, staticRewrite);
        if (sourceInfo == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String basePath = staticRewrite == null ? "." : staticRewrite.getTarget();
        XQuery xquery = broker.getBrokerPool().getXQueryService();
        XQueryPool xqyPool = broker.getBrokerPool().getXQueryPool();
        CompiledXQuery compiled = null;
        if (this.compiledCache) {
            compiled = xqyPool.borrowCompiledXQuery(broker, sourceInfo.source);
        }
        XQueryContext queryContext = compiled == null ? new XQueryContext((Database)broker.getBrokerPool()) : compiled.getContext();
        queryContext.setModuleLoadPath(sourceInfo.moduleLoadPath);
        this.declareVariables(queryContext, sourceInfo, staticRewrite, basePath, request, response);
        if (compiled == null) {
            try {
                compiled = xquery.compile(broker, queryContext, sourceInfo.source);
            }
            catch (IOException e) {
                throw new ServletException("Failed to read query from " + this.query, (Throwable)e);
            }
        }
        model.setSourceInfo(sourceInfo);
        try {
            Sequence sequence = xquery.execute(broker, compiled, null, outputProperties);
            return sequence;
        }
        finally {
            queryContext.runCleanupTasks();
            xqyPool.returnCompiledXQuery(sourceInfo.source, compiled);
        }
    }

    protected String adjustPathForSourceLookup(String basePath, String path) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("request path=" + path);
        }
        if (basePath.startsWith("xmldb:exist://") && path.startsWith(basePath.replace("xmldb:exist://", ""))) {
            path = path.replace(basePath.replace("xmldb:exist://", ""), "");
        } else if (path.startsWith("/db/")) {
            path = path.substring(4);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("adjusted request path=" + path);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SourceInfo findSource(HttpServletRequest request, DBBroker broker, String basePath) throws ServletException {
        Path cf;
        String realPath;
        Path baseDir;
        String requestURI = request.getRequestURI();
        String path = requestURI.substring(request.getContextPath().length());
        if (LOG.isTraceEnabled()) {
            LOG.trace("basePath=" + basePath);
        }
        path = this.adjustPathForSourceLookup(basePath, path);
        String[] components = path.split("/");
        SourceInfo sourceInfo = null;
        if (basePath.startsWith("xmldb:")) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Looking for controller.xql in the database, starting from: " + basePath);
            }
            try {
                Object doc;
                XmldbURI locationUri = XmldbURI.xmldbUriFor((String)basePath);
                Collection collection = broker.openCollection(locationUri, Lock.LockMode.READ_LOCK);
                if (collection == null) {
                    LOG.warn("Controller base collection not found: " + basePath);
                    return null;
                }
                Collection subColl = collection;
                DocumentImpl controllerDoc = null;
                for (int i = 0; i < components.length; ++i) {
                    doc = null;
                    try {
                        XmldbURI docUri;
                        if (components[i].length() <= 0 || !subColl.hasChildCollection(broker, XmldbURI.createInternal((String)components[i]))) break;
                        XmldbURI newSubCollURI = subColl.getURI().append(components[i]);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Inspecting sub-collection: " + newSubCollURI);
                        }
                        if ((subColl = broker.openCollection(newSubCollURI, Lock.LockMode.READ_LOCK)) == null) break;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Looking for controller.xql in " + subColl.getURI());
                        }
                        if ((doc = broker.getXMLResource(docUri = subColl.getURI().append("controller.xql"), Lock.LockMode.READ_LOCK)) == null) continue;
                        if (controllerDoc != null) {
                            controllerDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        }
                        controllerDoc = doc;
                        continue;
                    }
                    catch (PermissionDeniedException e2) {
                        LOG.debug("Permission denied while scanning for XQueryURLRewrite controllers: " + e2.getMessage(), (Throwable)e2);
                        break;
                    }
                    catch (Exception e3) {
                        LOG.debug("Bad collection URI: " + path);
                        break;
                    }
                    finally {
                        if (doc != null && controllerDoc == null) {
                            doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        }
                        if (subColl != null && subColl != collection) {
                            subColl.getLock().release(Lock.LockMode.READ_LOCK);
                        }
                    }
                }
                collection.getLock().release(Lock.LockMode.READ_LOCK);
                if (controllerDoc == null) {
                    try {
                        XmldbURI docUri = collection.getURI().append("controller.xql");
                        controllerDoc = broker.getXMLResource(docUri, Lock.LockMode.READ_LOCK);
                    }
                    catch (PermissionDeniedException e42) {
                        LOG.debug("Permission denied while scanning for XQueryURLRewrite controllers: " + e42.getMessage(), (Throwable)e42);
                    }
                }
                if (controllerDoc == null) {
                    LOG.warn("XQueryURLRewrite controller could not be found for path: " + path);
                    return null;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Found controller file: " + controllerDoc.getURI());
                }
                try {
                    if (controllerDoc.getResourceType() != 1 || !"application/xquery".equals(controllerDoc.getMetadata().getMimeType())) {
                        LOG.warn("XQuery resource: " + this.query + " is not an XQuery or declares a wrong mime-type");
                        SourceInfo e42 = null;
                        return e42;
                    }
                    String controllerPath = controllerDoc.getCollection().getURI().getRawCollectionPath();
                    sourceInfo = new SourceInfo((Source)new DBSource(broker, (BinaryDocument)controllerDoc, true), "xmldb:exist://" + controllerPath);
                    sourceInfo.controllerPath = controllerPath.substring(locationUri.getCollectionPath().length());
                    doc = sourceInfo;
                    return doc;
                }
                finally {
                    if (controllerDoc != null) {
                        controllerDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    }
                }
            }
            catch (URISyntaxException e) {
                LOG.warn("Bad URI for base path: " + e.getMessage(), (Throwable)e);
                return null;
            }
            catch (PermissionDeniedException e) {
                LOG.debug("Permission denied while scanning for XQueryURLRewrite controllers: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking for controller.xql in the filesystem, starting from: " + basePath);
        }
        if (!Files.isDirectory(baseDir = Paths.get(realPath = this.config.getServletContext().getRealPath(basePath), new String[0]), new LinkOption[0])) {
            LOG.warn("Base path for XQueryURLRewrite does not point to a directory");
            return null;
        }
        Path controllerFile = null;
        Path subDir = baseDir;
        for (int i = 0; i < components.length; ++i) {
            if (components[i].length() <= 0) continue;
            if (!Files.isDirectory(subDir = subDir.resolve(components[i]), new LinkOption[0])) break;
            Path cf2 = subDir.resolve("controller.xql");
            if (!Files.isReadable(cf2)) continue;
            controllerFile = cf2;
        }
        if (controllerFile == null && Files.isReadable(cf = baseDir.resolve("controller.xql"))) {
            controllerFile = cf;
        }
        if (controllerFile == null) {
            LOG.warn("XQueryURLRewrite controller could not be found");
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found controller file: " + controllerFile.toAbsolutePath());
        }
        String parentPath = controllerFile.getParent().toAbsolutePath().toString();
        sourceInfo = new SourceInfo((Source)new FileSource(controllerFile, true), parentPath);
        sourceInfo.controllerPath = parentPath.substring(baseDir.toAbsolutePath().toString().length());
        sourceInfo.controllerPath = sourceInfo.controllerPath.replace('\\', '/');
        return sourceInfo;
    }

    private SourceInfo getSource(DBBroker broker, String moduleLoadPath) throws ServletException {
        SourceInfo sourceInfo;
        block14: {
            if (this.query.startsWith("xmldb:")) {
                try {
                    XmldbURI locationUri = XmldbURI.xmldbUriFor((String)this.query);
                    DocumentImpl sourceDoc = null;
                    try {
                        sourceDoc = broker.getXMLResource(locationUri.toCollectionPathURI(), Lock.LockMode.READ_LOCK);
                        if (sourceDoc == null) {
                            throw new ServletException("XQuery resource: " + this.query + " not found in database");
                        }
                        if (sourceDoc.getResourceType() != 1 || !"application/xquery".equals(sourceDoc.getMetadata().getMimeType())) {
                            throw new ServletException("XQuery resource: " + this.query + " is not an XQuery or declares a wrong mime-type");
                        }
                        sourceInfo = new SourceInfo((Source)new DBSource(broker, (BinaryDocument)sourceDoc, true), locationUri.toString());
                        break block14;
                    }
                    catch (PermissionDeniedException e) {
                        throw new ServletException("permission denied to read module source from " + this.query);
                    }
                    finally {
                        if (sourceDoc != null) {
                            sourceDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        }
                    }
                }
                catch (URISyntaxException e) {
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                sourceInfo = new SourceInfo(SourceFactory.getSource((DBBroker)broker, (String)moduleLoadPath, (String)this.query, (boolean)true), moduleLoadPath);
            }
            catch (IOException e) {
                throw new ServletException("IO error while reading XQuery source: " + this.query);
            }
            catch (PermissionDeniedException e) {
                throw new ServletException("Permission denied while reading XQuery source: " + this.query);
            }
        }
        return sourceInfo;
    }

    private void declareVariables(XQueryContext context, SourceInfo sourceInfo, URLRewrite staticRewrite, String basePath, RequestWrapper request, HttpServletResponse response) throws XPathException {
        HttpRequestWrapper reqw = new HttpRequestWrapper((HttpServletRequest)request, "UTF-8", "UTF-8", false);
        HttpResponseWrapper respw = new HttpResponseWrapper(response);
        context.declareVariable("request:request", (Object)reqw);
        context.declareVariable("response:response", (Object)respw);
        context.declareVariable("session:session", (Object)reqw.getSession(false));
        context.declareVariable("exist:controller", (Object)sourceInfo.controllerPath);
        request.setAttribute("$exist:controller", sourceInfo.controllerPath);
        context.declareVariable("exist:root", (Object)basePath);
        request.setAttribute("$exist:root", basePath);
        context.declareVariable("exist:context", (Object)request.getContextPath());
        request.setAttribute("$exist:context", request.getContextPath());
        String prefix = staticRewrite == null ? null : staticRewrite.getPrefix();
        context.declareVariable("exist:prefix", (Object)(prefix == null ? "" : prefix));
        request.setAttribute("$exist:prefix", prefix == null ? "" : prefix);
        String path = sourceInfo.controllerPath.length() > 0 && !"/".equals(sourceInfo.controllerPath) ? request.getInContextPath().substring(sourceInfo.controllerPath.length()) : request.getInContextPath();
        int p = path.lastIndexOf(59);
        if (p != -1) {
            path = path.substring(0, p);
        }
        context.declareVariable("exist:path", (Object)path);
        request.setAttribute("$exist:path", path);
        String resource = "";
        Matcher nameMatcher = NAME_REGEX.matcher(path);
        if (nameMatcher.matches()) {
            resource = nameMatcher.group(1);
        }
        context.declareVariable("exist:resource", (Object)resource);
        request.setAttribute("$exist:resource", resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nexist:path = " + path + "\nexist:resource = " + resource + "\nexist:controller = " + sourceInfo.controllerPath);
        }
    }

    private static class CachingServletInputStream
    extends ServletInputStream {
        protected ByteArrayInputStream istream;

        public CachingServletInputStream(byte[] data) {
            this.istream = data == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(data);
        }

        public int read() throws IOException {
            return this.istream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.istream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.istream.read(b, off, len);
        }

        public int available() throws IOException {
            return this.istream.available();
        }

        public boolean isFinished() {
            return this.istream.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }
    }

    private static class CachingServletOutputStream
    extends ServletOutputStream {
        protected ByteArrayOutputStream ostream = new ByteArrayOutputStream(512);

        private CachingServletOutputStream() {
        }

        protected byte[] getData() {
            return this.ostream.toByteArray();
        }

        public void write(int b) throws IOException {
            this.ostream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.ostream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.ostream.write(b, off, len);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException();
        }
    }

    private class CachingResponseWrapper
    extends HttpServletResponseWrapper {
        protected CachingServletOutputStream sos;
        protected PrintWriter writer;
        protected int status;
        protected String contentType;
        protected boolean cache;

        public CachingResponseWrapper(HttpServletResponse servletResponse, boolean cache) {
            super(servletResponse);
            this.sos = null;
            this.writer = null;
            this.status = 200;
            this.contentType = null;
            this.cache = cache;
        }

        public PrintWriter getWriter() throws IOException {
            if (!this.cache) {
                return super.getWriter();
            }
            if (this.sos != null) {
                throw new IOException("getWriter cannnot be called after getOutputStream");
            }
            this.sos = new CachingServletOutputStream();
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.sos), this.getCharacterEncoding()));
            }
            return this.writer;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (!this.cache) {
                return super.getOutputStream();
            }
            if (this.writer != null) {
                throw new IOException("getOutputStream cannnot be called after getWriter");
            }
            if (this.sos == null) {
                this.sos = new CachingServletOutputStream();
            }
            return this.sos;
        }

        public byte[] getData() {
            return this.sos != null ? this.sos.getData() : null;
        }

        public void setContentType(String type) {
            if (this.contentType != null) {
                return;
            }
            this.contentType = type;
            if (!this.cache) {
                super.setContentType(type);
            }
        }

        public String getContentType() {
            return this.contentType != null ? this.contentType : super.getContentType();
        }

        public void setHeader(String name, String value) {
            if ("Content-Type".equals(name)) {
                this.setContentType(value);
            } else {
                super.setHeader(name, value);
            }
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int i) {
            this.status = i;
            super.setStatus(i);
        }

        public void setStatus(int i, String msg) {
            this.status = i;
            super.setStatus(i, msg);
        }

        public void sendError(int i, String msg) throws IOException {
            this.status = i;
            super.sendError(i, msg);
        }

        public void sendError(int i) throws IOException {
            this.status = i;
            super.sendError(i);
        }

        public void setContentLength(int i) {
            if (!this.cache) {
                super.setContentLength(i);
            }
        }

        public void flushBuffer() throws IOException {
            if (!this.cache) {
                super.flushBuffer();
            }
        }

        public void flush() throws IOException {
            if (this.cache && this.contentType != null) {
                super.setContentType(this.contentType);
            }
            if (this.sos != null) {
                ServletOutputStream out = super.getOutputStream();
                out.write(this.sos.getData());
                out.flush();
            }
        }
    }

    public static class RequestWrapper
    extends HttpServletRequestWrapper {
        Map<String, List<String>> addedParams = new HashMap<String, List<String>>();
        Map attributes = new HashMap();
        ServletInputStream sis = null;
        BufferedReader reader = null;
        String contentType = null;
        int contentLength = 0;
        String characterEncoding = null;
        String method = null;
        String inContextPath = null;
        String servletPath;
        String basePath = null;
        boolean allowCaching = true;

        private void addNameValue(String name, String value, Map<String, List<String>> map) {
            List<String> values = map.get(name);
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(value);
            map.put(name, values);
        }

        protected RequestWrapper(HttpServletRequest request) {
            super(request);
            for (Map.Entry param : request.getParameterMap().entrySet()) {
                for (String paramValue : (String[])param.getValue()) {
                    this.addNameValue((String)param.getKey(), paramValue, this.addedParams);
                }
            }
            this.contentType = request.getContentType();
        }

        protected void allowCaching(boolean cache) {
            this.allowCaching = cache;
        }

        public String getRequestURI() {
            String uri = this.inContextPath == null ? super.getRequestURI() : this.getContextPath() + this.inContextPath;
            int pos = uri.indexOf(";jsessionid=");
            if (pos > 0) {
                uri = uri.substring(0, pos);
            }
            return uri;
        }

        public String getInContextPath() {
            if (this.inContextPath == null) {
                return this.getRequestURI().substring(this.getContextPath().length());
            }
            return this.inContextPath;
        }

        public void setInContextPath(String path) {
            this.inContextPath = path;
        }

        public String getMethod() {
            if (this.method == null) {
                return super.getMethod();
            }
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setPaths(String requestURI, String servletPath) {
            this.inContextPath = requestURI;
            this.servletPath = servletPath == null ? requestURI : servletPath;
        }

        public void setBasePath(String base) {
            this.basePath = base;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void removePathPrefix(String base) {
            this.setPaths(this.getInContextPath().substring(base.length()), this.servletPath != null ? this.servletPath.substring(base.length()) : null);
        }

        public String getServletPath() {
            return this.servletPath == null ? super.getServletPath() : this.servletPath;
        }

        public String getPathInfo() {
            String path = this.getInContextPath();
            String sp = this.getServletPath();
            if (sp == null) {
                return null;
            }
            if (path.length() < sp.length()) {
                LOG.error("Internal error: servletPath = " + sp + " is longer than path = " + path);
                return null;
            }
            return path.length() == sp.length() ? null : path.substring(sp.length());
        }

        public String getPathTranslated() {
            String pathInfo = this.getPathInfo();
            if (pathInfo == null) {
                super.getPathTranslated();
            }
            if (pathInfo == null) {
                return null;
            }
            return super.getSession().getServletContext().getRealPath(pathInfo);
        }

        protected void setData(byte[] data) {
            if (data == null) {
                data = new byte[]{};
            }
            this.contentLength = data.length;
            this.sis = new CachingServletInputStream(data);
        }

        public void addParameter(String name, String value) {
            this.addNameValue(name, value, this.addedParams);
        }

        public String getParameter(String name) {
            List<String> paramValues = this.addedParams.get(name);
            if (paramValues != null && paramValues.size() > 0) {
                return paramValues.get(0);
            }
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            for (Map.Entry<String, List<String>> param : this.addedParams.entrySet()) {
                List<String> values = param.getValue();
                if (values != null) {
                    parameterMap.put(param.getKey(), values.toArray(new String[values.size()]));
                    continue;
                }
                parameterMap.put(param.getKey(), new String[0]);
            }
            return parameterMap;
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.addedParams.keySet());
        }

        public String[] getParameterValues(String name) {
            List<String> values = this.addedParams.get(name);
            if (values != null) {
                return values.toArray(new String[values.size()]);
            }
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.sis == null) {
                return super.getInputStream();
            }
            return this.sis;
        }

        public BufferedReader getReader() throws IOException {
            if (this.sis == null) {
                return super.getReader();
            }
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)this.sis, this.getCharacterEncoding()));
            }
            return this.reader;
        }

        public String getContentType() {
            if (this.contentType == null) {
                return super.getContentType();
            }
            return this.contentType;
        }

        protected void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public int getContentLength() {
            if (this.sis == null) {
                return super.getContentLength();
            }
            return this.contentLength;
        }

        public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
            this.characterEncoding = encoding;
        }

        public String getCharacterEncoding() {
            if (this.characterEncoding == null) {
                return super.getCharacterEncoding();
            }
            return this.characterEncoding;
        }

        public String getHeader(String s) {
            if ("If-Modified-Since".equals(s) && !this.allowCaching) {
                return null;
            }
            return super.getHeader(s);
        }

        public long getDateHeader(String s) {
            if ("If-Modified-Since".equals(s) && !this.allowCaching) {
                return -1L;
            }
            return super.getDateHeader(s);
        }
    }

    private static class SourceInfo {
        Source source;
        String controllerPath = "";
        String moduleLoadPath;

        private SourceInfo(Source source, String moduleLoadPath) {
            this.source = source;
            this.moduleLoadPath = moduleLoadPath;
        }
    }

    private static class ModelAndView {
        URLRewrite rewrite = null;
        List<URLRewrite> views = new LinkedList<URLRewrite>();
        List<URLRewrite> errorHandlers = null;
        boolean useCache = false;
        SourceInfo sourceInfo = null;

        private ModelAndView() {
        }

        public void setSourceInfo(SourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
        }

        public SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        public void setModel(URLRewrite model) {
            this.rewrite = model;
        }

        public URLRewrite getModel() {
            return this.rewrite;
        }

        public void addErrorHandler(URLRewrite handler) {
            if (this.errorHandlers == null) {
                this.errorHandlers = new LinkedList<URLRewrite>();
            }
            this.errorHandlers.add(handler);
        }

        public void addView(URLRewrite view) {
            this.views.add(view);
        }

        public boolean hasViews() {
            return this.views.size() > 0;
        }

        public boolean hasErrorHandlers() {
            return this.errorHandlers != null && this.errorHandlers.size() > 0;
        }

        public boolean useCache() {
            return this.useCache;
        }

        public void setUseCache(boolean useCache) {
            this.useCache = useCache;
        }
    }
}

