/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webstart;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.start.LatestFileResolver;
import org.exist.util.FileUtils;
import org.exist.webstart.JnlpHelper;

public class JnlpJarFiles {
    private static final Logger LOGGER = LogManager.getLogger(JnlpJarFiles.class);
    private final Map<String, Path> allFiles = new HashMap<String, Path>();
    private final Path mainJar;
    private final String[] allJarNames = new String[]{"antlr-%latest%", "cglib-nodep-%latest%", "clj-ds-%latest%", "commons-codec-%latest%", "commons-collections-%latest%", "commons-io-%latest%", "commons-logging-%latest%", "commons-pool-%latest%", "jargo-%latest%", "gnu-crypto-%latest%", "j8fu-%latest%", "jackson-core-%latest%", "jcip-annotations-%latest%", "jline-%latest%", "jta-%latest%", "log4j-api-%latest%", "log4j-core-%latest%", "log4j-jul-%latest%", "log4j-slf4j-impl-%latest%", "pkg-java-fork", "quartz-%latest%", "rsyntaxtextarea-%latest%", "slf4j-api-%latest%", "ws-commons-util-%latest%", "xmldb", "xmlrpc-client-%latest%", "xmlrpc-common-%latest%"};
    private final LatestFileResolver jarFileResolver = new LatestFileResolver();

    private Path getJarFromLocation(Path folder, String jarFileBaseName) {
        String fileToFind = folder.normalize().toAbsolutePath().toString() + File.separatorChar + jarFileBaseName + ".jar";
        String resolvedFile = this.jarFileResolver.getResolvedFileName(fileToFind);
        Path jar = Paths.get(resolvedFile, new String[0]).normalize();
        if (Files.exists(jar, new LinkOption[0])) {
            LOGGER.debug(String.format("Found match: %s for file pattern: %s", resolvedFile, fileToFind));
            return jar;
        }
        LOGGER.error(String.format("Could not resolve file pattern: %s", fileToFind));
        return null;
    }

    private void addToJars(Path jar) {
        if (jar != null && FileUtils.fileName((Path)jar).endsWith(".jar")) {
            this.allFiles.put(FileUtils.fileName((Path)jar), jar);
            Path pkgz = this.getJarPackGz(jar);
            if (pkgz != null) {
                this.allFiles.put(FileUtils.fileName((Path)pkgz), pkgz);
            }
        }
    }

    public JnlpJarFiles(JnlpHelper jnlpHelper) {
        LOGGER.info("Initializing jar files Webstart");
        LOGGER.debug(String.format("Number of webstart jars=%s", this.allJarNames.length));
        for (String jarname : this.allJarNames) {
            Path location = this.getJarFromLocation(jnlpHelper.getCoreJarsFolder(), jarname);
            this.addToJars(location);
        }
        this.mainJar = jnlpHelper.getExistJarFolder().resolve("exist.jar");
        this.addToJars(this.mainJar);
    }

    public List<Path> getAllWebstartJars() {
        return this.allFiles.values().stream().filter(file -> FileUtils.fileName((Path)file).endsWith(".jar")).collect(Collectors.toList());
    }

    public Path getJarFile(String key) {
        return this.allFiles.get(key);
    }

    private Path getJarPackGz(Path jarName) {
        String path = jarName.toAbsolutePath().toString() + ".pack.gz";
        Path pkgz = Paths.get(path, new String[0]);
        if (Files.exists(pkgz, new LinkOption[0])) {
            return pkgz;
        }
        return null;
    }

    public long getLastModified() throws IOException {
        return this.mainJar == null ? -1L : Files.getLastModifiedTime(this.mainJar, new LinkOption[0]).toMillis();
    }
}

